/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.office;

import java.awt.Color;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.Drawing;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Picture;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellReference;
import org.apache.poi.util.IOUtils;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIExcelUtil {
    private static Logger log = LogManager.getLogger(POIExcelUtil.class);

    public static Workbook createWorkbook() {
        return POIExcelUtil.createWorkbook(false);
    }

    public static Workbook createWorkbook(boolean flag) {
        Object wb = flag ? new XSSFWorkbook() : new HSSFWorkbook();
        return wb;
    }

    public static void addPicture(Workbook wb, Sheet sheet, String picFileName, int picType, int row, int col) {
        FileInputStream is = null;
        try {
            is = new FileInputStream(picFileName);
            byte[] bytes = IOUtils.toByteArray((InputStream)is);
            int pictureIdx = wb.addPicture(bytes, picType);
            ((InputStream)is).close();
            CreationHelper helper = wb.getCreationHelper();
            Drawing drawing = sheet.createDrawingPatriarch();
            ClientAnchor anchor = helper.createClientAnchor();
            anchor.setCol1(col);
            anchor.setRow1(row);
            Picture pict = drawing.createPicture(anchor, pictureIdx);
            pict.resize();
        }
        catch (Exception e) {
            try {
                if (is != null) {
                    ((InputStream)is).close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
    }

    public static Cell createCell(CellStyle style, Row row, short column) {
        return POIExcelUtil.createCell(style, row, column, (short)2, (short)2);
    }

    public static Cell createCell(CellStyle style, Row row, short column, short halign, short valign) {
        Cell cell = row.createCell((int)column);
        POIExcelUtil.setAlign(style, halign, valign);
        cell.setCellStyle(style);
        return cell;
    }

    public static void mergeCell(Sheet sheet, int firstRow, int lastRow, int firstCol, int lastCol) {
        sheet.addMergedRegion(new CellRangeAddress(firstRow, lastRow, firstCol, lastCol));
    }

    public static CellStyle setAlign(CellStyle style, short halign, short valign) {
        style.setAlignment(halign);
        style.setVerticalAlignment(valign);
        return style;
    }

    public static CellStyle setBorder(CellStyle style, short borderStyle, short borderColor) {
        style.setBorderBottom(borderStyle);
        style.setBottomBorderColor(borderColor);
        style.setBorderLeft(borderStyle);
        style.setLeftBorderColor(borderColor);
        style.setBorderRight(borderStyle);
        style.setRightBorderColor(borderColor);
        style.setBorderTop(borderStyle);
        style.setTopBorderColor(borderColor);
        return style;
    }

    public static CellStyle setBackColorByCustom(XSSFCellStyle style, int red, int green, int blue) {
        style.setFillForegroundColor(new XSSFColor(new Color(red, green, blue)));
        style.setFillPattern((short)1);
        return style;
    }

    public static CellStyle setBackColor(CellStyle style, short color) {
        style.setFillForegroundColor(color);
        style.setFillPattern((short)1);
        return style;
    }

    public static CellStyle setBackColor(CellStyle style, short backColor, short fillPattern) {
        style.setFillBackgroundColor(backColor);
        style.setFillPattern(fillPattern);
        return style;
    }

    public static CellStyle setFont(Font font, CellStyle style, short fontSize, short color, String fontName) {
        font.setFontHeightInPoints(color);
        font.setFontName(fontName);
        font.setColor(color);
        style.setFont(font);
        return style;
    }

    public static CellStyle setDataFormat(CreationHelper createHelper, CellStyle style, String formartData) {
        style.setDataFormat(createHelper.createDataFormat().getFormat(formartData));
        return style;
    }

    public static boolean createExcel(Workbook wb, String fileName) {
        boolean flag = true;
        FileOutputStream fileOut = null;
        try {
            File file = new File(fileName);
            File parent = file.getParentFile();
            if (parent != null && !parent.exists()) {
                parent.mkdirs();
            }
            fileOut = new FileOutputStream(fileName);
            wb.write((OutputStream)fileOut);
            fileOut.close();
        }
        catch (Exception e) {
            flag = false;
            if (fileOut != null) {
                try {
                    fileOut.close();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
            }
            e.printStackTrace();
        }
        return flag;
    }

    public static Workbook readExcel(String filePathName) {
        FileInputStream inp = null;
        Workbook wb = null;
        try {
            inp = new FileInputStream(filePathName);
            wb = WorkbookFactory.create((InputStream)inp);
            ((InputStream)inp).close();
        }
        catch (Exception e) {
            try {
                if (null != inp) {
                    ((InputStream)inp).close();
                }
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            e.printStackTrace();
        }
        return wb;
    }

    public static Map readCell(Sheet sheet) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        for (Row row : sheet) {
            block7: for (Cell cell : row) {
                CellReference cellRef = new CellReference(row.getRowNum(), cell.getColumnIndex());
                String key = cellRef.formatAsString();
                switch (cell.getCellType()) {
                    case 1: {
                        map.put(key, cell.getRichStringCellValue().getString());
                        continue block7;
                    }
                    case 0: {
                        if (DateUtil.isCellDateFormatted((Cell)cell)) {
                            map.put(key, cell.getDateCellValue());
                            continue block7;
                        }
                        map.put(key, cell.getNumericCellValue());
                        continue block7;
                    }
                    case 4: {
                        map.put(key, cell.getBooleanCellValue());
                        continue block7;
                    }
                    case 2: {
                        map.put(key, cell.getCellFormula());
                        continue block7;
                    }
                }
                System.out.println();
                map.put(key, "");
            }
        }
        return map;
    }

    private static void replaceDetail(Workbook workbook, Sheet sheet, String detailKey, List<Map<String, String>> detailList) {
        if (detailList == null || detailList.size() == 0) {
            return;
        }
        int detailSize = detailList.size();
        Cell detailCell = POIExcelUtil.findCell(sheet, detailKey);
        if (detailCell == null) {
            return;
        }
        int detailRow = detailCell.getRowIndex();
        int detailColunm = detailCell.getColumnIndex();
        for (int i = 1; i < detailSize; ++i) {
            POIExcelUtil.copyRow(workbook, sheet, detailRow, detailRow + i);
        }
        int[] rownum = POIExcelUtil.getDetailColunmNum(sheet, detailRow, detailColunm, detailList.get(0).size());
        for (Map<String, String> detailMap : detailList) {
            float defaultRowHeight;
            int colunm = 0;
            Row thisRow = sheet.getRow(detailRow);
            float maxHeight = defaultRowHeight = thisRow.getHeightInPoints();
            for (Map.Entry<String, String> entry : detailMap.entrySet()) {
                Cell thisCell = thisRow.getCell(rownum[colunm]);
                float thisHeight = POIExcelUtil.getExcelCellAutoHeight(entry.getValue(), defaultRowHeight, POIExcelUtil.getMergedCellNum(thisCell) * sheet.getColumnWidth(rownum[colunm]) / 256);
                if (thisHeight > maxHeight) {
                    maxHeight = thisHeight;
                }
                if (thisCell == null) {
                    thisCell = thisRow.createCell(rownum[colunm]);
                    thisCell.setCellValue(entry.getValue());
                } else {
                    thisCell.setCellValue(entry.getValue());
                    thisCell.getCellStyle().setWrapText(true);
                }
                ++colunm;
            }
            thisRow.setHeightInPoints(maxHeight);
            ++detailRow;
        }
    }

    private static int[] getDetailColunmNum(Sheet sheet, int detailRow, int detalColunm, int detailMapSize) {
        int[] rowNum = new int[detailMapSize];
        int mergedRow = 0;
        int j = 0;
        for (int i = 0; i < detailMapSize + mergedRow; ++i) {
            Cell cell = sheet.getRow(detailRow).getCell(i + detalColunm);
            if (POIExcelUtil.isMergedRegionNotFirstCell(cell)) {
                ++mergedRow;
                continue;
            }
            rowNum[j++] = i + detalColunm;
        }
        return rowNum;
    }

    private static int getMergedCellNum(Cell cell) {
        if (cell == null) {
            return 1;
        }
        Sheet sheet = cell.getSheet();
        CellRangeAddress range = null;
        int mergedNum = sheet.getNumMergedRegions();
        for (int i = 0; i < mergedNum; ++i) {
            range = sheet.getMergedRegion(i);
            if (cell.getColumnIndex() != range.getFirstColumn() || cell.getRowIndex() != range.getFirstRow()) continue;
            return range.getLastColumn() - range.getFirstColumn() + 1;
        }
        return 1;
    }

    private static boolean isMergedRegionNotFirstCell(Cell cell) {
        if (cell == null) {
            return false;
        }
        Sheet sheet = cell.getSheet();
        CellRangeAddress range = null;
        int mergedNum = sheet.getNumMergedRegions();
        for (int i = 0; i < mergedNum; ++i) {
            range = sheet.getMergedRegion(i);
            if (cell.getColumnIndex() <= range.getFirstColumn() || cell.getColumnIndex() > range.getLastColumn() || cell.getRowIndex() != range.getFirstRow()) continue;
            return true;
        }
        return false;
    }

    private static void replaceHeader(Sheet sheet, Map<String, String> replaceTextMap) {
        for (Row thisRow : sheet) {
            float defaultRowHeight;
            boolean isFound = false;
            float maxHeight = defaultRowHeight = thisRow.getHeightInPoints();
            for (Cell thisCell : thisRow) {
                CellReference cellRef = new CellReference(thisRow.getRowNum(), thisCell.getColumnIndex());
                switch (thisCell.getCellType()) {
                    case 1: {
                        String targetText = thisCell.getRichStringCellValue().getString();
                        if (targetText == null || targetText.trim().equals("") || !replaceTextMap.containsKey(targetText)) break;
                        float thisHeight = POIExcelUtil.getExcelCellAutoHeight(replaceTextMap.get(targetText), defaultRowHeight, POIExcelUtil.getMergedCellNum(thisCell) * sheet.getColumnWidth(thisCell.getColumnIndex()) / 256);
                        if (thisHeight > maxHeight) {
                            maxHeight = thisHeight;
                        }
                        isFound = true;
                        thisCell.setCellValue(replaceTextMap.get(targetText));
                        thisCell.getCellStyle().setWrapText(true);
                        log.info(" Sheet[" + sheet.getSheetName() + "]\u884c:" + (thisCell.getRowIndex() + 1) + "\u5217:" + POIExcelUtil.getColLetter(thisCell.getColumnIndex()) + " " + targetText + " replace " + targetText + " -> " + replaceTextMap.get(targetText));
                        break;
                    }
                    case 0: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
            if (!isFound) continue;
            thisRow.setHeightInPoints(maxHeight);
        }
    }

    private static Cell findCell(Sheet sheet, String findStr) {
        for (Row row : sheet) {
            for (Cell cell : row) {
                CellReference cellRef = new CellReference(row.getRowNum(), cell.getColumnIndex());
                switch (cell.getCellType()) {
                    case 1: {
                        String targetText = cell.getRichStringCellValue().getString();
                        if (targetText == null || targetText.trim().equals("") || !targetText.contains(findStr)) break;
                        return cell;
                    }
                    case 0: {
                        break;
                    }
                    case 4: {
                        break;
                    }
                    case 2: {
                        break;
                    }
                }
            }
        }
        return null;
    }

    private static String getColLetter(int colIndex) {
        String ch = "";
        ch = colIndex < 26 ? "" + (char)(colIndex + 65) : "" + (char)(colIndex / 26 + 65 - 1) + (char)(colIndex % 26 + 65);
        return ch;
    }

    public static void traversal(List<String> filesPathList, String directoryPath) {
        File dir = new File(directoryPath);
        File[] files = dir.listFiles();
        if (files == null) {
            return;
        }
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                POIExcelUtil.traversal(filesPathList, files[i].getAbsolutePath());
                continue;
            }
            filesPathList.add(files[i].getAbsolutePath());
        }
    }

    private static void copyRow(Workbook workbook, Sheet worksheet, int sourceRowNum, int destinationRowNum) {
        int i;
        Row newRow = worksheet.getRow(destinationRowNum);
        Row sourceRow = worksheet.getRow(sourceRowNum);
        if (newRow != null) {
            worksheet.shiftRows(destinationRowNum, worksheet.getLastRowNum(), 1);
        } else {
            newRow = worksheet.createRow(destinationRowNum);
        }
        block8: for (i = 0; i < sourceRow.getLastCellNum(); ++i) {
            Cell oldCell = sourceRow.getCell(i);
            Cell newCell = newRow.createCell(i);
            if (oldCell == null) {
                newCell = null;
                continue;
            }
            CellStyle newCellStyle = workbook.createCellStyle();
            newCellStyle.cloneStyleFrom(oldCell.getCellStyle());
            newCell.setCellStyle(newCellStyle);
            if (newCell.getCellComment() != null) {
                newCell.setCellComment(oldCell.getCellComment());
            }
            if (oldCell.getHyperlink() != null) {
                newCell.setHyperlink(oldCell.getHyperlink());
            }
            newCell.setCellType(oldCell.getCellType());
            switch (oldCell.getCellType()) {
                case 3: {
                    newCell.setCellValue(oldCell.getStringCellValue());
                    continue block8;
                }
                case 4: {
                    newCell.setCellValue(oldCell.getBooleanCellValue());
                    continue block8;
                }
                case 5: {
                    newCell.setCellErrorValue(oldCell.getErrorCellValue());
                    continue block8;
                }
                case 2: {
                    newCell.setCellFormula(oldCell.getCellFormula());
                    continue block8;
                }
                case 0: {
                    newCell.setCellValue(oldCell.getNumericCellValue());
                    continue block8;
                }
                case 1: {
                    newCell.setCellValue(oldCell.getRichStringCellValue());
                }
            }
        }
        for (i = 0; i < worksheet.getNumMergedRegions(); ++i) {
            CellRangeAddress cellRangeAddress = worksheet.getMergedRegion(i);
            if (cellRangeAddress.getFirstRow() != sourceRow.getRowNum()) continue;
            CellRangeAddress newCellRangeAddress = new CellRangeAddress(newRow.getRowNum(), newRow.getRowNum() + (cellRangeAddress.getFirstRow() - cellRangeAddress.getLastRow()), cellRangeAddress.getFirstColumn(), cellRangeAddress.getLastColumn());
            worksheet.addMergedRegion(newCellRangeAddress);
        }
    }

    public static float getExcelCellAutoHeight(String str, float defaultRowHeight, int fontCountInline) {
        int defaultCount = 0;
        for (int i = 0; i < str.length(); ++i) {
            int ff = POIExcelUtil.getregex(str.substring(i, i + 1));
            defaultCount += ff;
        }
        if (defaultCount > fontCountInline) {
            return (float)(defaultCount / fontCountInline + 1) * defaultRowHeight;
        }
        return defaultRowHeight;
    }

    public static int getregex(String charStr) {
        if (charStr == " ") {
            return 1;
        }
        if (Pattern.compile("^[A-Za-z0-9]+$").matcher(charStr).matches()) {
            return 1;
        }
        if (Pattern.compile("[\u4e00-\u9fa5]+$").matcher(charStr).matches()) {
            return 2;
        }
        if (Pattern.compile("[^x00-xff]").matcher(charStr).matches()) {
            return 2;
        }
        return 1;
    }

    public static void main(String[] args) throws Exception {
        HashMap<String, String> replaceTextMap = new HashMap<String, String>();
        replaceTextMap.put("#\u5bc4\u5355\u5730\u5740", "[\u5bc4\u5355\u5730\u5740\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7]");
        replaceTextMap.put("#\u5382\u5546\u7f16\u53f7", "[\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7]");
        replaceTextMap.put("#\u5382\u5546\u540d\u79f0", "[\u5382\u5546\u540d\u79f0\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7]");
        Workbook wb = POIExcelUtil.readExcel("F:\\PO\u5dee\u5f02\u62a5\u8868.xls");
        Sheet sheet = wb.getSheetAt(0);
        POIExcelUtil.replaceHeader(sheet, replaceTextMap);
        ArrayList<Map<String, String>> detailList = new ArrayList<Map<String, String>>();
        TreeMap<String, String> detailMap = new TreeMap<String, String>();
        detailMap.put("ID11", "\u5382\u5546\u7f16\u53f7");
        detailMap.put("ID12", "\u5382\u5546\u7f16\u53f7");
        detailMap.put("ID13", "\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7\u5382\u5546\u7f16\u53f7");
        detailMap.put("ID14", "ID14");
        detailMap.put("ID15", "ID15");
        detailMap.put("ID16", "ID16");
        detailList.add(detailMap);
        detailMap = new TreeMap();
        detailMap.put("ID21", "ID21");
        detailMap.put("ID22", "ID22");
        detailMap.put("ID23", "ID23");
        detailMap.put("ID24", "ID24");
        detailMap.put("ID25", "ID25");
        detailMap.put("ID26", "ID26");
        detailList.add(detailMap);
        POIExcelUtil.replaceDetail(wb, sheet, "#detail", detailList);
        POIExcelUtil.replaceDetail(wb, sheet, "#detail1", detailList);
        POIExcelUtil.createExcel(wb, "F:\\PO\u5dee\u5f02\u62a5\u8868_replace.xls");
    }
}

