/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.office;

import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.net.URL;
import java.net.URLConnection;
import java.text.DateFormat;
import java.text.DecimalFormat;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFCellStyle;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFDateUtil;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.DateUtil;

public class ExcelUtil {
    private ExcelUtil() {
    }

    public static final ExcelUtil getInstance() {
        return LazyHolder.INSTANCE;
    }

    public static void main(String[] args) {
        ExcelUtil util = new ExcelUtil();
        ArrayList<Integer> cellNum = new ArrayList<Integer>();
        cellNum.add(5);
        cellNum.add(9);
        cellNum.add(10);
        cellNum.add(9);
        cellNum.add(8);
        try {
            List<List<String>> contents = util.getContent1("E:/Book1.xls", cellNum);
            System.out.println(contents.toString());
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public List<List<List<String>>> getContent(String filePath, List<Integer> cellNum) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<List<String>>> content = new ArrayList<List<List<String>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            ArrayList sheetContent = new ArrayList();
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty) continue;
                sheetContent.add(rowContent);
            }
            content.add(sheetContent);
        }
        return content;
    }

    public List<List<List<String>>> getContent(String filePath, List<Integer> cellNum, Integer col) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<List<String>>> content = new ArrayList<List<List<String>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            int j;
            sheet = hwb.getSheetAt(i);
            ArrayList sheetContent = new ArrayList();
            int n = j = col >= 1 ? col : 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c;
                    HSSFCell cell = row.getCell(k);
                    if (cell != null) {
                        cell.setCellType(1);
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (!isAllEmpty) {
                    sheetContent.add(rowContent);
                }
                ++j;
            }
            content.add(sheetContent);
        }
        return content;
    }

    public Map<String, ArrayList<ArrayList<String>>> getContentFromUrl(String urlPath, List<Integer> cellValidNumList, List<Integer> colValidNumList) throws Exception {
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            return null;
        }
        URL url = new URL(urlPath);
        URLConnection uc = url.openConnection();
        InputStream in = uc.getInputStream();
        return this.getContentFromInputStream(in, cellValidNumList, colValidNumList);
    }

    private Map<String, ArrayList<ArrayList<String>>> getContentFromInputStream(InputStream fis, List<Integer> cellValidNumList, List<Integer> colValidNumList) throws Exception {
        if (cellValidNumList == null || cellValidNumList.isEmpty() || colValidNumList == null || colValidNumList.isEmpty()) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFRow row = null;
        HashMap<String, ArrayList<ArrayList<String>>> contentMap = new HashMap<String, ArrayList<ArrayList<String>>>();
        int sheetNum = 0;
        sheetNum = cellValidNumList.size() > colValidNumList.size() ? colValidNumList.size() : cellValidNumList.size();
        for (int i = 0; i < hwb.getNumberOfSheets() && i != sheetNum; ++i) {
            int j;
            HSSFSheet sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            Integer col = colValidNumList.get(i);
            if (col == null) continue;
            int n = j = col >= 0 ? col : 0;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                Integer cellNum = cellValidNumList.get(i);
                for (int k = cellNum.intValue(); k < row.getLastCellNum(); ++k) {
                    String c;
                    HSSFCell cell = row.getCell(k);
                    if (cell == null) continue;
                    if (cell != null) {
                        cell.setCellType(1);
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (!isAllEmpty) {
                    ((ArrayList)contentMap.get(sheet.getSheetName())).add(rowContent);
                }
                ++j;
            }
        }
        return contentMap;
    }

    public Map<String, ArrayList<ArrayList<String>>> getContent(String filePath, List<Integer> cellValidNumList, List<Integer> colValidNumList) throws Exception {
        if (StringUtils.isEmpty((CharSequence)filePath)) {
            return null;
        }
        FileInputStream fis = new FileInputStream(filePath);
        return this.getContentFromInputStream(fis, cellValidNumList, colValidNumList);
    }

    public List<List<String>> getContent1(String filePath, List<Integer> cellNum) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = 1; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content.add(rowContent);
            }
        }
        return content;
    }

    public List<List<String>> getContent2(InputStream fis, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        if (fis == null) {
            return null;
        }
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content.add(rowContent);
            }
        }
        return content;
    }

    public List<List<String>> getContent3(String filePath, List<Integer> cellNum, int startRow) throws NoSuchMethodException, SecurityException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, IOException {
        FileInputStream fis = new FileInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        ArrayList<List<String>> content = new ArrayList<List<String>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            sheet = hwb.getSheetAt(i);
            String sheetName = sheet.getSheetName();
            for (int j = startRow; j < sheet.getPhysicalNumberOfRows(); ++j) {
                String name;
                row = sheet.getRow(j);
                if (row == null) continue;
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                for (int k = 0; k < cellNum.get(i); ++k) {
                    String c = this.getCellValue1(row.getCell(k));
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (isAllEmpty || StringUtils.isEmpty((CharSequence)(name = (String)rowContent.get(0)))) continue;
                rowContent.add(sheetName);
                content.add(rowContent);
            }
        }
        return content;
    }

    private String getCellValue(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        String value = null;
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                long dd = (long)cell.getNumericCellValue();
                value = dd + "";
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 2: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
        }
        return value;
    }

    private String getCellValue1(HSSFCell cell) {
        if (cell == null) {
            return null;
        }
        String value = null;
        switch (cell.getCellType()) {
            case 1: {
                value = cell.getRichStringCellValue().getString();
                break;
            }
            case 0: {
                value = this.parseExcel(cell);
                break;
            }
            case 3: {
                value = "";
                break;
            }
            case 2: {
                value = String.valueOf(cell.getCellFormula());
                break;
            }
            case 4: {
                value = String.valueOf(cell.getBooleanCellValue());
                break;
            }
            case 5: {
                value = String.valueOf(cell.getErrorCellValue());
                break;
            }
        }
        return value;
    }

    public static Date getDate(Cell cell) {
        String dateStr;
        if (cell == null) {
            return null;
        }
        if (cell.getCellType() == 0) {
            return cell.getDateCellValue();
        }
        if (cell.getCellType() == 1 && StringUtils.isNotEmpty(dateStr = cell.getStringCellValue())) {
            Date date = null;
            try {
                date = DateFormat.getDateInstance().parse(dateStr.trim());
            }
            catch (ParseException parseException) {
                // empty catch block
            }
            return date;
        }
        return null;
    }

    private String parseExcel(HSSFCell cell) {
        String result = "";
        if (HSSFDateUtil.isCellDateFormatted((Cell)cell)) {
            SimpleDateFormat sdf = null;
            sdf = cell.getCellStyle().getDataFormat() == HSSFDataFormat.getBuiltinFormat((String)"h:mm") ? new SimpleDateFormat("HH:mm") : new SimpleDateFormat("yyyy-MM-dd");
            Date date = cell.getDateCellValue();
            result = sdf.format(date);
        } else if (cell.getCellStyle().getDataFormat() == 58) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
            double value = cell.getNumericCellValue();
            Date date = DateUtil.getJavaDate((double)value);
            result = sdf.format(date);
        } else {
            double value = cell.getNumericCellValue();
            HSSFCellStyle style = cell.getCellStyle();
            DecimalFormat format = new DecimalFormat();
            String temp = style.getDataFormatString();
            if (temp.equals("General")) {
                format.applyPattern("#");
            }
            result = format.format(value);
        }
        return result;
    }

    public InputStream getOssInputStream(String urlPath) throws Exception {
        if (StringUtils.isEmpty((CharSequence)urlPath)) {
            return null;
        }
        URL url = new URL(urlPath);
        URLConnection uc = url.openConnection();
        InputStream in = uc.getInputStream();
        return in;
    }

    public void downExcelBySheetNames(String filePath, List<String> sheetNames, OutputStream out) throws Exception {
        ArrayList<String> noNeedSheetNames = new ArrayList<String>();
        FileInputStream fis = new FileInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook((InputStream)fis);
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            noNeedSheetNames.add(hwb.getSheetAt(i).getSheetName());
        }
        if (sheetNames != null && sheetNames.size() > 0) {
            for (String name : sheetNames) {
                noNeedSheetNames.remove(name);
            }
        }
        if (noNeedSheetNames != null && noNeedSheetNames.size() > 0) {
            for (String name : noNeedSheetNames) {
                hwb.removeSheetAt(hwb.getSheetIndex(name));
            }
        }
        hwb.write(out);
        hwb.close();
    }

    public Map<String, ArrayList<ArrayList<String>>> getContent(String filePath, Map<String, Integer> validColMap, Map<String, Integer> startRowMap) throws Exception {
        InputStream fis = this.getOssInputStream(filePath);
        HSSFWorkbook hwb = new HSSFWorkbook(fis);
        HSSFSheet sheet = hwb.getSheetAt(0);
        HSSFRow row = null;
        HashMap<String, ArrayList<ArrayList<String>>> contentMap = new HashMap<String, ArrayList<ArrayList<String>>>();
        for (int i = 0; i < hwb.getNumberOfSheets(); ++i) {
            int j;
            sheet = hwb.getSheetAt(i);
            contentMap.put(sheet.getSheetName(), new ArrayList());
            Integer startRow = startRowMap.get(sheet.getSheetName());
            if (startRow == null) continue;
            int n = j = startRow >= 1 ? startRow : 1;
            while (j < sheet.getPhysicalNumberOfRows()) {
                row = sheet.getRow(j);
                ArrayList<String> rowContent = new ArrayList<String>();
                boolean isAllEmpty = true;
                Integer cellNum = validColMap.get(sheet.getSheetName());
                for (int k = 0; k < cellNum; ++k) {
                    String c;
                    HSSFCell cell = row.getCell(k);
                    if (cell != null) {
                        cell.setCellType(1);
                    }
                    String string = c = cell == null ? "" : row.getCell(k).getStringCellValue();
                    if (c == null) {
                        c = "";
                    }
                    if (!isAllEmpty || !StringUtils.isEmpty((CharSequence)c)) {
                        isAllEmpty = false;
                    }
                    rowContent.add(c);
                }
                if (!isAllEmpty) {
                    ((ArrayList)contentMap.get(sheet.getSheetName())).add(rowContent);
                }
                ++j;
            }
        }
        hwb.close();
        return contentMap;
    }

    private static class LazyHolder {
        private static final ExcelUtil INSTANCE = new ExcelUtil();

        private LazyHolder() {
        }
    }
}

