/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.bean;

import cn.smarthse.modules.platform.core.framework.utils.DateUtils;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.common.utils.BinaryUtil;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.MatchMode;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PolicyConditions;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URL;
import java.net.URLDecoder;
import java.security.KeyFactory;
import java.security.PublicKey;
import java.security.Signature;
import java.security.spec.X509EncodedKeySpec;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import net.sf.json.JSONObject;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class OssClientBean {
    private Logger logger = LogManager.getLogger(this.getClass());
    private static final String FILE_NAME_POINT_STRING = ".";
    private String domain = "oss-cn-hangzhou.aliyuncs.com";
    private String endpoint = "https://" + this.domain;
    private String accessKeyId = "LTAI4Fckd7ybKCP4XwT1vuWF";
    private String accessKeySecret = "L3u6oOZomnTpD6HFSgZFbPhUBS8Wio";
    private String bucketName = "yanfa-oss-file1";
    private boolean asynch = false;
    private int exptime = 7200;
    private OSSClient client = null;
    private boolean publicread = true;

    public String getUrl(String urlfile) {
        return this.getUrl(urlfile, null, this.exptime);
    }

    public String getUrl(String urlfile, String filename, int exptime) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (urlfile.indexOf(this.domain) >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("https://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append(this.domain).append("/").append(urlfile);
            if (StringUtils.isNotEmpty(filename)) {
                url.append("?response-content-disposition=attachment;filename=" + filename);
            }
            return url.toString();
        }
        Date exp = DateUtils.addSecond(new Date(), exptime);
        URL url = null;
        url = StringUtils.isEmpty((CharSequence)filename) ? this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET) : this.generatePresignedUrl(this.bucketName, filename, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    private URL generatePresignedUrl(String bucketName, String attachmentFilename, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        responseHeaders.setContentDisposition("attachment;filename=\"" + attachmentFilename + "\"");
        request.setResponseHeaders(responseHeaders);
        return this.getClient().generatePresignedUrl(request);
    }

    public String getUrlBybucket(String bucket, String urlfile) {
        if (StringUtils.isEmpty((CharSequence)urlfile) || StringUtils.isEmpty((CharSequence)bucket)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("https://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append("oss-cn-hangzhou.aliyuncs.com").append("/").append(urlfile);
            return url.toString();
        }
        Date exp = DateUtils.addSecond(new Date(), this.exptime);
        URL url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String getThumbnail(String urlfile, String styleName) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        URL url = null;
        Date exp = DateUtils.addSecond(new Date(), this.exptime);
        urlfile = urlfile + "@!" + styleName;
        url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, contentMD5, null);
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5, String contentType) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(file.length());
        if (StringUtils.isNotEmpty(fileFullname)) {
            objectMeta.setContentDisposition("attachment;filename=" + fileFullname);
        }
        if (StringUtils.isNotEmpty(contentType)) {
            objectMeta.setContentType(contentType);
        }
        if (StringUtils.isNotEmpty(contentMD5)) {
            objectMeta.setContentMD5(contentMD5);
        }
        return this.OSSPutObject(serviceFilename, file, serviceDir, objectMeta);
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, ObjectMetadata objectMeta) {
        StringBuffer ossfile = new StringBuffer();
        try {
            FileInputStream input = new FileInputStream(file);
            PutObjectResult resultObject = this.getClient().putObject(this.bucketName, serviceDir + "/" + serviceFilename, (InputStream)input, objectMeta);
            ossfile.append(serviceDir).append("/").append(serviceFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
        return ossfile.toString();
    }

    public String OSSPutObject(String key, MultipartFile multipartFile, String serviceName, String contentMD5) {
        CommonsMultipartFile commonsMultipartFile = (CommonsMultipartFile)multipartFile;
        DiskFileItem diskFileItem = (DiskFileItem)commonsMultipartFile.getFileItem();
        File file = diskFileItem.getStoreLocation();
        String fileSuffix = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf(FILE_NAME_POINT_STRING));
        return this.OSSPutObject(key + fileSuffix, file, serviceName, multipartFile.getOriginalFilename(), contentMD5);
    }

    public OSSObject downloadFile(String file) {
        OSSObject obj = null;
        try {
            obj = this.getClient().getObject(this.bucketName, file);
        }
        catch (OSSException oe) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + oe.getMessage());
        }
        catch (ClientException ce) {
            this.logger.error("\u963f\u91cc\u4e91\u8fde\u63a5\u5931\u8d25:" + ce.getMessage());
        }
        catch (NullPointerException n) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + n.getMessage());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String fileOssurl, String destFilePath, String fileName) throws IOException {
        OSSObject ossObject = this.downloadFile(fileOssurl);
        if (StringUtils.isEmpty((CharSequence)fileOssurl) || StringUtils.isEmpty((CharSequence)destFilePath) || ossObject == null || ossObject.getObjectContent() == null) {
            return fileName;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        String[] names = new String[]{fileName};
        File file = this.getNoRepeatDestFilePath(destFilePath, names);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            reader = ossObject.getObjectContent();
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = reader.read(b)) > 0) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u672a\u627e\u5230:" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:" + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return names[0];
    }

    private File getNoRepeatDestFilePath(String destFilePath, String[] fileName) {
        if (!destFilePath.endsWith(File.separator)) {
            destFilePath = destFilePath + File.separator;
        }
        String fileSuffix = "";
        String pointStr = FILE_NAME_POINT_STRING;
        int pointIndex = fileName[0].lastIndexOf(FILE_NAME_POINT_STRING);
        if (pointIndex > 0) {
            fileSuffix = fileName[0].substring(pointIndex + 1);
            fileName[0] = fileName[0].substring(0, pointIndex);
        } else {
            pointStr = "";
        }
        File file = new File(destFilePath + fileName[0] + pointStr + fileSuffix);
        int i = 1;
        while (file.exists()) {
            file = new File(destFilePath + fileName[0] + i + pointStr + fileSuffix);
            ++i;
        }
        fileName[0] = i > 1 ? fileName[0] + --i + pointStr + fileSuffix : fileName[0] + pointStr + fileSuffix;
        return file;
    }

    public ObjectMetadata getObjectMetadataByUrl(String url) {
        ObjectMetadata metadata = this.getClient().getObjectMetadata(this.bucketName, url);
        return metadata;
    }

    public InputStream getInputStreamByUrl(String fileUrl) {
        InputStream reader = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection urlCon = (HttpURLConnection)url.openConnection();
            urlCon.setConnectTimeout(5000);
            urlCon.setReadTimeout(5000);
            reader = urlCon.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return reader;
    }

    public Map<String, String> getPostSignature(String dir) throws Exception {
        String host = "https://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
        long expireTime = 30L;
        long expireEndTime = System.currentTimeMillis() + expireTime * 1000L;
        Date expiration = new Date(expireEndTime);
        PolicyConditions policyConds = new PolicyConditions();
        policyConds.addConditionItem("content-length-range", 0L, 1048576000L);
        policyConds.addConditionItem(MatchMode.StartWith, "key", dir);
        String postPolicy = this.getClient().generatePostPolicy(expiration, policyConds);
        byte[] binaryData = postPolicy.getBytes("utf-8");
        String encodedPolicy = BinaryUtil.toBase64String((byte[])binaryData);
        String postSignature = this.getClient().calculatePostSignature(postPolicy);
        LinkedHashMap<String, String> respMap = new LinkedHashMap<String, String>();
        respMap.put("accessid", this.accessKeyId);
        respMap.put("policy", encodedPolicy);
        respMap.put("signature", postSignature);
        respMap.put("dir", dir);
        respMap.put("host", host);
        respMap.put("expire", String.valueOf(expireEndTime / 1000L));
        JSONObject jasonCallback = new JSONObject();
        StringBuffer callbackBody = new StringBuffer("{");
        callbackBody.append("bucket:").append("${bucket}");
        callbackBody.append(",filename:").append("${object}");
        callbackBody.append(",etag:").append("${etag}");
        callbackBody.append(",size:").append("${size}");
        callbackBody.append(",mimeType:").append("${mimeType}");
        callbackBody.append(",height:").append("${imageInfo.height}");
        callbackBody.append(",width:").append("${imageInfo.width}");
        callbackBody.append(",format:").append("${imageInfo.format}");
        callbackBody.append("}");
        jasonCallback.put((Object)"callbackBody", (Object)callbackBody.toString());
        jasonCallback.put((Object)"callbackBodyType", (Object)"application/json");
        String base64CallbackBody = BinaryUtil.toBase64String((byte[])jasonCallback.toString().getBytes());
        respMap.put("callback", base64CallbackBody);
        return respMap;
    }

    public boolean VerifyOSSCallbackRequest(HttpServletRequest request, String ossCallbackBody) throws NumberFormatException, IOException {
        String decodeUri;
        boolean ret = false;
        String autorizationInput = new String(request.getHeader("Authorization"));
        String pubKeyInput = request.getHeader("x-oss-pub-key-url");
        byte[] authorization = BinaryUtil.fromBase64String((String)autorizationInput);
        byte[] pubKey = BinaryUtil.fromBase64String((String)pubKeyInput);
        String pubKeyAddr = new String(pubKey);
        if (!pubKeyAddr.startsWith("http://gosspublic.alicdn.com/") && !pubKeyAddr.startsWith("https://gosspublic.alicdn.com/")) {
            System.out.println("pub key addr must be oss addrss");
            return false;
        }
        String retString = this.executeGet(pubKeyAddr);
        retString = retString.replace("-----BEGIN PUBLIC KEY-----", "");
        retString = retString.replace("-----END PUBLIC KEY-----", "");
        String queryString = request.getQueryString();
        String uri = request.getRequestURI();
        String authStr = decodeUri = URLDecoder.decode(uri, "UTF-8");
        if (queryString != null && !queryString.equals("")) {
            authStr = authStr + "?" + queryString;
        }
        authStr = authStr + "\n" + ossCallbackBody;
        ret = OssClientBean.doCheck(authStr, authorization, retString);
        return ret;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String executeGet(String url) {
        BufferedReader in = null;
        String content = null;
        try {
            DefaultHttpClient client = new DefaultHttpClient();
            HttpGet request = new HttpGet();
            request.setURI(new URI(url));
            CloseableHttpResponse response = client.execute((HttpUriRequest)request);
            in = new BufferedReader(new InputStreamReader(response.getEntity().getContent()));
            StringBuffer sb = new StringBuffer("");
            String line = "";
            String NL = System.getProperty("line.separator");
            while ((line = in.readLine()) != null) {
                sb.append(line + NL);
            }
            in.close();
            content = sb.toString();
            return content;
        }
        catch (Exception e) {}
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
            return content;
        }
    }

    public static boolean doCheck(String content, byte[] sign, String publicKey) {
        try {
            KeyFactory keyFactory = KeyFactory.getInstance("RSA");
            byte[] encodedKey = BinaryUtil.fromBase64String((String)publicKey);
            PublicKey pubKey = keyFactory.generatePublic(new X509EncodedKeySpec(encodedKey));
            Signature signature = Signature.getInstance("MD5withRSA");
            signature.initVerify(pubKey);
            signature.update(content.getBytes());
            boolean bverify = signature.verify(sign);
            return bverify;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public String getHost() {
        return "https://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    public OSSClient getClient() {
        if (this.client == null) {
            this.client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        }
        return this.client;
    }

    public int getExptime() {
        return this.exptime;
    }

    public void setExptime(int exptime) {
        this.exptime = exptime;
    }

    public boolean isPublicread() {
        return this.publicread;
    }

    public void setPublicread(boolean publicread) {
        this.publicread = publicread;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

