/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.utils;

import cn.smarthse.modules.platform.core.framework.utils.IdcardValidator;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class IdcardInfoExtractor {
    private static Map<String, String> cityCodeMap = new HashMap<String, String>(){
        {
            this.put("11", "\u5317\u4eac");
            this.put("12", "\u5929\u6d25");
            this.put("13", "\u6cb3\u5317");
            this.put("14", "\u5c71\u897f");
            this.put("15", "\u5185\u8499\u53e4");
            this.put("21", "\u8fbd\u5b81");
            this.put("22", "\u5409\u6797");
            this.put("23", "\u9ed1\u9f99\u6c5f");
            this.put("31", "\u4e0a\u6d77");
            this.put("32", "\u6c5f\u82cf");
            this.put("33", "\u6d59\u6c5f");
            this.put("34", "\u5b89\u5fbd");
            this.put("35", "\u798f\u5efa");
            this.put("36", "\u6c5f\u897f");
            this.put("37", "\u5c71\u4e1c");
            this.put("41", "\u6cb3\u5357");
            this.put("42", "\u6e56\u5317");
            this.put("43", "\u6e56\u5357");
            this.put("44", "\u5e7f\u4e1c");
            this.put("45", "\u5e7f\u897f");
            this.put("46", "\u6d77\u5357");
            this.put("50", "\u91cd\u5e86");
            this.put("51", "\u56db\u5ddd");
            this.put("52", "\u8d35\u5dde");
            this.put("53", "\u4e91\u5357");
            this.put("54", "\u897f\u85cf");
            this.put("61", "\u9655\u897f");
            this.put("62", "\u7518\u8083");
            this.put("63", "\u9752\u6d77");
            this.put("64", "\u5b81\u590f");
            this.put("65", "\u65b0\u7586");
            this.put("71", "\u53f0\u6e7e");
            this.put("81", "\u9999\u6e2f");
            this.put("82", "\u6fb3\u95e8");
            this.put("91", "\u56fd\u5916");
        }
    };

    public static String getProvince(String idcard) {
        if (!IdcardValidator.isValidatedAllIdcard(idcard)) {
            return "";
        }
        if (idcard.length() == 15) {
            idcard = IdcardValidator.convertIdcarBy15bit(idcard);
        }
        String provinceId = idcard.substring(0, 2);
        Set<String> key = cityCodeMap.keySet();
        String province = "";
        for (String id : key) {
            if (!id.equals(provinceId)) continue;
            province = cityCodeMap.get(id);
            break;
        }
        return province;
    }

    public static String getGender(String idcard) {
        if (!IdcardValidator.isValidatedAllIdcard(idcard)) {
            return "";
        }
        if (idcard.length() == 15) {
            idcard = IdcardValidator.convertIdcarBy15bit(idcard);
        }
        String id17 = idcard.substring(16, 17);
        String gender = "";
        gender = Integer.parseInt(id17) % 2 != 0 ? "\u7537" : "\u5973";
        return gender;
    }

    public static String getBirthday(String idcard) {
        if (!IdcardValidator.isValidatedAllIdcard(idcard)) {
            return "";
        }
        if (idcard.length() == 15) {
            idcard = IdcardValidator.convertIdcarBy15bit(idcard);
        }
        String birthday = idcard.substring(6, 14);
        Date birthdate = null;
        try {
            birthdate = new SimpleDateFormat("yyyyMMdd").parse(birthday);
        }
        catch (ParseException e) {
            e.printStackTrace();
            return "";
        }
        GregorianCalendar currentDay = new GregorianCalendar();
        currentDay.setTime(birthdate);
        int year = currentDay.get(1);
        int month = currentDay.get(2) + 1;
        int day = currentDay.get(5);
        String formatbirthday = year + "-" + month + "-" + day;
        return formatbirthday;
    }

    public static void main(String[] args) {
        String GEN = IdcardInfoExtractor.getGender("330327198709210419");
        System.out.println("------" + GEN);
    }
}

