/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.office;

import cn.smarthse.modules.platform.core.framework.utils.DateUtils;
import cn.smarthse.modules.platform.core.framework.utils.NumberUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.poi.hssf.usermodel.HSSFDataFormat;
import org.apache.poi.hssf.usermodel.HSSFRichTextString;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.RichTextString;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.xssf.streaming.SXSSFCell;
import org.apache.poi.xssf.streaming.SXSSFRow;
import org.apache.poi.xssf.streaming.SXSSFSheet;
import org.apache.poi.xssf.streaming.SXSSFWorkbook;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class ExportExcel<T> {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport(String title, String[] headers, List<T> dataset, OutputStream out) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(title);
        SXSSFRow row = sheet.createRow(0);
        for (int i = 0; i < headers.length; ++i) {
            row.createCell(i).setCellValue(headers[i]);
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            Field[] fields = t.getClass().getDeclaredFields();
            for (int i = 0; i < fields.length; ++i) {
                SXSSFCell cell = row.createCell(i);
                Field field = fields[i];
                String fieldName = field.getName();
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        CellStyle style = workbook.createCellStyle();
                        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"yyyy-MM-dd"));
                        cell.setCellStyle(style);
                        Date date = (Date)value;
                        textValue = DateUtils.formatDate(date);
                    } else if (value instanceof BigDecimal) {
                        CellStyle style = workbook.createCellStyle();
                        style.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"#,##0"));
                        cell.setCellStyle(style);
                        textValue = value.toString();
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    Pattern p = Pattern.compile("^//d+(//.//d+)?$");
                    Matcher matcher = p.matcher(textValue);
                    if (matcher.matches()) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport2(String title, String[] colums, List<T> dataset, OutputStream out) {
        SXSSFWorkbook workbook = new SXSSFWorkbook();
        SXSSFSheet sheet = workbook.createSheet(title);
        CellStyle styleDate = workbook.createCellStyle();
        styleDate.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"yyyy-MM-dd"));
        CellStyle cellStyleComon = workbook.createCellStyle();
        cellStyleComon.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"G/\u901a\u7528\u683c\u5f0f"));
        SXSSFRow row = sheet.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = sheet.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                SXSSFCell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        cell.setCellStyle(styleDate);
                        Date date = (Date)value;
                        textValue = DateUtils.formatDate(date);
                    } else if (value instanceof BigDecimal) {
                        cell.setCellStyle(cellStyleComon);
                        textValue = value.toString();
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    if (NumberUtil.isNumber(textValue)) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        try {
            workbook.write(out);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            try {
                workbook.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void simpleExport3(String title, String[] colums, List<T> dataset, String filePath) throws IOException {
        File file = new File(filePath);
        try {
            file.getParentFile().mkdirs();
        }
        catch (Exception exception) {
            // empty catch block
        }
        XSSFWorkbook workbook1 = new XSSFWorkbook((InputStream)new FileInputStream(new File(filePath)));
        SXSSFWorkbook sxssfWorkbook = new SXSSFWorkbook(workbook1, 100);
        SXSSFSheet first = sxssfWorkbook.getSheetAt(0);
        XSSFCellStyle styleDate = workbook1.createCellStyle();
        styleDate.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"yyyy-MM-dd"));
        XSSFCellStyle cellStyleComon = workbook1.createCellStyle();
        cellStyleComon.setDataFormat(HSSFDataFormat.getBuiltinFormat((String)"G/\u901a\u7528\u683c\u5f0f"));
        Row row = first.createRow(0);
        ArrayList<String> headers = new ArrayList<String>();
        ArrayList<String> fieldNames = new ArrayList<String>();
        for (String colum : colums) {
            String[] t = colum.split("\\|");
            if (t.length != 2) continue;
            headers.add(t[0]);
            fieldNames.add(t[1]);
        }
        for (int i = 0; i < headers.size(); ++i) {
            row.createCell(i).setCellValue((String)headers.get(i));
        }
        Iterator<T> it = dataset.iterator();
        int index = 0;
        while (it.hasNext()) {
            row = first.createRow(++index);
            T t = it.next();
            for (int i = 0; i < fieldNames.size(); ++i) {
                Cell cell = row.createCell(i);
                String fieldName = (String)fieldNames.get(i);
                String getMethodName = "get" + fieldName.substring(0, 1).toUpperCase() + fieldName.substring(1);
                try {
                    Class<?> tCls = t.getClass();
                    Method getMethod = tCls.getMethod(getMethodName, new Class[0]);
                    Object value = getMethod.invoke(t, new Object[0]);
                    String textValue = null;
                    if (value == null) continue;
                    if (value instanceof Integer) {
                        int intValue = (Integer)value;
                        cell.setCellValue((double)intValue);
                    } else if (value instanceof Float) {
                        float fValue = ((Float)value).floatValue();
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(fValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Double) {
                        double dValue = (Double)value;
                        HSSFRichTextString richText = new HSSFRichTextString(String.valueOf(dValue));
                        cell.setCellValue((RichTextString)richText);
                    } else if (value instanceof Long) {
                        long longValue = (Long)value;
                        cell.setCellValue((double)longValue);
                    } else if (value instanceof Date) {
                        cell.setCellStyle((CellStyle)styleDate);
                        Date date = (Date)value;
                        textValue = DateUtils.formatDate(date);
                    } else if (value instanceof BigDecimal) {
                        cell.setCellStyle((CellStyle)cellStyleComon);
                        textValue = value.toString();
                    } else {
                        textValue = value.toString();
                    }
                    if (textValue == null) continue;
                    if (NumberUtil.isNumber(textValue)) {
                        cell.setCellValue(Double.parseDouble(textValue));
                        continue;
                    }
                    cell.setCellValue(textValue);
                }
                catch (SecurityException e) {
                    e.printStackTrace();
                }
                catch (NoSuchMethodException e) {
                    e.printStackTrace();
                }
                catch (IllegalArgumentException e) {
                    e.printStackTrace();
                }
                catch (IllegalAccessException e) {
                    e.printStackTrace();
                }
                catch (InvocationTargetException e) {
                    e.printStackTrace();
                }
                continue;
            }
        }
        FileOutputStream out = new FileOutputStream(filePath);
        sxssfWorkbook.write((OutputStream)out);
        out.close();
    }
}

