/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.mail;

import cn.smarthse.modules.platform.core.framework.mail.EmailModel;
import cn.smarthse.modules.platform.core.framework.mail.IEmailService;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import freemarker.template.Configuration;
import freemarker.template.Template;
import java.io.File;
import java.util.Date;
import java.util.Map;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.core.io.FileSystemResource;
import org.springframework.core.io.InputStreamSource;
import org.springframework.core.task.TaskExecutor;
import org.springframework.mail.javamail.JavaMailSender;
import org.springframework.mail.javamail.MimeMessageHelper;
import org.springframework.ui.ModelMap;
import org.springframework.ui.freemarker.FreeMarkerTemplateUtils;

public class FreemarkerEmailServiceImpl
implements IEmailService {
    private static Logger logger = LogManager.getLogger(FreemarkerEmailServiceImpl.class);
    @Autowired(required=false)
    private JavaMailSender emailTemplate;
    @Autowired(required=false)
    private Configuration freemarkerConfiguration;
    @Value(value="${email.username}")
    private String email_username;
    @Autowired(required=false)
    private TaskExecutor taskExecutor;

    @Override
    public void sendEmail(EmailModel emailModel, Date date) throws MessagingException {
        this.sendEmail(emailModel, null, null, date);
    }

    @Override
    public void sendEmail(EmailModel emailModel, String templateName, ModelMap model, Date date) throws MessagingException {
        MimeMessage message = this.emailTemplate.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);
        helper.setFrom(this.email_username);
        helper.setValidateAddresses(true);
        if (StringUtils.isNotBlank((CharSequence)templateName)) {
            helper.setText(this.geFreeMarkerTemplateContent((Map<String, Object>)model, templateName), true);
        } else if (StringUtils.isNotBlank((CharSequence)emailModel.getEmailContent())) {
            helper.setText(emailModel.getEmailContent(), true);
        }
        helper.setSubject(emailModel.getSubject());
        helper.setCc(emailModel.getCc());
        helper.setTo(emailModel.getReceivers());
        helper.setBcc(emailModel.getBcc());
        if (null == date) {
            date = new Date();
        }
        helper.setSentDate(date);
        if (emailModel.getAttachFile() != null) {
            for (File file : emailModel.getAttachFile()) {
                FileSystemResource fileSystemResource = new FileSystemResource(file);
                helper.addAttachment(file.getName(), (InputStreamSource)fileSystemResource);
            }
        }
        this.addSendMailTask(message);
    }

    private void addSendMailTask(final MimeMessage message) {
        if (this.taskExecutor != null) {
            try {
                this.taskExecutor.execute(new Runnable(){

                    @Override
                    public void run() {
                        FreemarkerEmailServiceImpl.this.emailTemplate.send(message);
                    }
                });
            }
            catch (Exception e) {
                logger.error("\u90ae\u4ef6\u53d1\u9001\u5f02\u5e38,\u90ae\u4ef6\u8be6\u7ec6\u4fe1\u606f\u4e3a{}", (Object)e.getMessage());
            }
        } else {
            this.emailTemplate.send(message);
        }
    }

    public String geFreeMarkerTemplateContent(Map<String, Object> model, String templateName) {
        StringBuffer content = new StringBuffer();
        try {
            content.append(FreeMarkerTemplateUtils.processTemplateIntoString((Template)this.freemarkerConfiguration.getTemplate(templateName), model));
            return content.toString();
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("Exception occured while processing fmtemplate:" + e.getMessage(), (Throwable)e);
            return "";
        }
    }

    @Override
    public void sendEmailByOnce(EmailModel emailModel, String templateName, ModelMap model, Date date) throws MessagingException {
        MimeMessage message = this.emailTemplate.createMimeMessage();
        MimeMessageHelper helper = new MimeMessageHelper(message);
        helper.setFrom(this.email_username);
        helper.setValidateAddresses(true);
        if (StringUtils.isNotBlank((CharSequence)templateName)) {
            helper.setText(this.geFreeMarkerTemplateContent((Map<String, Object>)model, templateName), true);
        } else if (StringUtils.isNotBlank((CharSequence)emailModel.getEmailContent())) {
            helper.setText(emailModel.getEmailContent(), true);
        }
        helper.setSubject(emailModel.getSubject());
        helper.setCc(emailModel.getCc());
        helper.setTo(emailModel.getReceivers());
        helper.setBcc(emailModel.getBcc());
        if (null == date) {
            date = new Date();
        }
        helper.setSentDate(date);
        if (emailModel.getAttachFile() != null) {
            for (File file : emailModel.getAttachFile()) {
                FileSystemResource fileSystemResource = new FileSystemResource(file);
                helper.addAttachment(file.getName(), (InputStreamSource)fileSystemResource);
            }
        }
        this.emailTemplate.send(message);
    }
}

