/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.encrypt;

import cn.smarthse.modules.platform.core.framework.encrypt.BASE64Util;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.Key;
import java.security.NoSuchAlgorithmException;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;

public class AESUtil {
    public static final String KEY_ALGORITHM = "AES";
    public static final String ECB_CIPHER_ALGORITHM = "AES/ECB/PKCS5Padding";
    public static final String CBC_CIPHER_ALGORITHM = "AES/CBC/PKCS5Padding";
    public static final String PLAIN_TEXT = "MANUTD is the greatest club in the world";
    public static final byte[] IVPARAMETERS = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};

    public static String encyrpt(String text) {
        SecretKey key = AESUtil.restoreSecretKey(IVPARAMETERS);
        byte[] encodedText = AESUtil.AesEcbEncode(text.getBytes(), key);
        return Base64.encodeBase64String((byte[])encodedText);
    }

    public static String decrypt(String text) {
        SecretKey key = AESUtil.restoreSecretKey(IVPARAMETERS);
        byte[] bytes = BASE64Util.base64ToByteArray(text);
        return AESUtil.AesEcbDecode(bytes, key);
    }

    public static void main(String[] arg) {
        String sourceText = "97775600357439902";
        String encodeText1111 = AESUtil.encyrpt(sourceText);
        System.out.println(sourceText + "\u52a0\u5bc6\u540e\uff1a" + encodeText1111);
        System.out.println("\u89e3\u5bc6\u540e\uff1a" + AESUtil.decrypt(encodeText1111));
    }

    public static byte[] AesEcbEncode(byte[] plainText, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance(ECB_CIPHER_ALGORITHM);
            cipher.init(1, key);
            return cipher.doFinal(plainText);
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String AesEcbDecode(byte[] decodedText, SecretKey key) {
        try {
            Cipher cipher = Cipher.getInstance(ECB_CIPHER_ALGORITHM);
            cipher.init(2, key);
            return new String(cipher.doFinal(decodedText));
        }
        catch (InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] AesCbcEncode(byte[] plainText, SecretKey key, byte[] IVParameter) {
        try {
            IvParameterSpec ivParameterSpec = new IvParameterSpec(IVParameter);
            Cipher cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM);
            cipher.init(1, (Key)key, ivParameterSpec);
            return cipher.doFinal(plainText);
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static String AesCbcDecode(byte[] decodedText, SecretKey key, byte[] IVParameter) {
        IvParameterSpec ivParameterSpec = new IvParameterSpec(IVParameter);
        try {
            Cipher cipher = Cipher.getInstance(CBC_CIPHER_ALGORITHM);
            cipher.init(2, (Key)key, ivParameterSpec);
            return new String(cipher.doFinal(decodedText));
        }
        catch (InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static byte[] generateAESSecretKey() {
        try {
            KeyGenerator keyGenerator = KeyGenerator.getInstance(KEY_ALGORITHM);
            return keyGenerator.generateKey().getEncoded();
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SecretKey restoreSecretKey(byte[] secretBytes) {
        SecretKeySpec secretKey = new SecretKeySpec(secretBytes, KEY_ALGORITHM);
        return secretKey;
    }
}

