/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.database.generator;

import cn.smarthse.modules.platform.core.framework.database.generator.SnowflakeIdWorker;
import java.util.Date;

public final class SnowflakeIdHelper {
    private static long workerId = 0L;
    private static long datacenterId = 0L;
    private static SnowflakeIdWorker idWorker = new SnowflakeIdWorker(workerId, datacenterId);

    private SnowflakeIdHelper() {
    }

    public static SnowflakeIdWorker getSnowflakeIdWorker() {
        return idWorker;
    }

    public static long generateId() {
        return idWorker.nextId();
    }

    public static String generateStrId() {
        return idWorker.nextId() + "";
    }

    public static long getTimestampValue(long id) {
        long twepoch = 0L;
        long time = id >> 22;
        return time + twepoch;
    }

    public static Date getTimestamp(long id) {
        return new Date(SnowflakeIdHelper.getTimestampValue(id));
    }

    public static long getGenerateIdStart(Date date) {
        long sequenceBits;
        long sequence = 0L;
        long workerIdBits = 5L;
        long datacenterIdBits = 5L;
        long workerIdShift = sequenceBits = 12L;
        long datacenterIdShift = sequenceBits + workerIdBits;
        long timestampLeftShift = sequenceBits + workerIdBits + datacenterIdBits;
        long twepoch = 0L;
        long timestamp = date.getTime();
        return timestamp - twepoch << (int)timestampLeftShift | datacenterId << (int)datacenterIdShift | workerId << (int)workerIdShift | sequence;
    }

    public static long getDatacenterId() {
        return datacenterId;
    }

    public void setDatacenterId(long datacenterId) {
        SnowflakeIdHelper.datacenterId = datacenterId;
    }

    public static long getWorkerId() {
        return workerId;
    }

    public void setWorkerId(long workerId) {
        SnowflakeIdHelper.workerId = workerId;
    }

    public static void init(long workerId, long datacenterId) {
        SnowflakeIdHelper.workerId = workerId;
        SnowflakeIdHelper.datacenterId = datacenterId;
        idWorker = new SnowflakeIdWorker(workerId, datacenterId);
    }

    public void init() {
        idWorker = new SnowflakeIdWorker(workerId, datacenterId);
    }

    public static void main(String[] args) {
        System.out.println(SnowflakeIdHelper.generateId());
    }
}

