/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.cache.ehcache;

import java.io.Serializable;
import java.util.List;
import java.util.Map;
import net.sf.ehcache.Cache;
import net.sf.ehcache.CacheManager;
import net.sf.ehcache.Element;
import net.sf.ehcache.search.Attribute;
import net.sf.ehcache.search.Query;
import net.sf.ehcache.search.Result;
import net.sf.ehcache.search.Results;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EhCacheUtils {
    private static Logger logger = LogManager.getLogger(EhCacheUtils.class);
    private Cache cache = null;

    public EhCacheUtils(CacheManager cacheManager, String cacheName) {
        this.cache = cacheManager.getCache(cacheName);
    }

    public void put(Object key, Object value) {
        Element oldElement = this.cache.get(key);
        if (value instanceof Map && oldElement != null && oldElement.getValue() != null) {
            Map oldMap = (Map)((Object)oldElement.getValue());
            Map newMap = (Map)value;
            oldMap.putAll(newMap);
            Element newElement = new Element(key, (Object)oldMap);
            this.cache.put(newElement);
        } else {
            Element newElement = new Element(key, value);
            this.cache.put(newElement);
        }
    }

    public void add(Object key, Object value) {
        Element oldElement = this.cache.get(key);
        if (oldElement instanceof Map && value instanceof Map) {
            Map oldMap = (Map)oldElement;
            Map newMap = (Map)value;
            oldMap.putAll(newMap);
            Element newElement = new Element(key, (Object)oldMap);
            this.cache.put(newElement);
        } else {
            Element newElement = new Element(key, value);
            this.cache.put(newElement);
        }
    }

    public Object get(Object key) {
        Element element = this.cache.get(key);
        if (null == element) {
            return null;
        }
        return element.getObjectValue();
    }

    public Object getObjectBeginWith(String key) {
        Element element = this.cache.get((Serializable)((Object)key));
        if (null == element) {
            return null;
        }
        Attribute name = this.cache.getSearchAttribute("name");
        Query query = this.cache.createQuery();
        query.includeKeys();
        query.includeValues();
        query.addCriteria(name.ilike(key + "?"));
        Results results = query.execute();
        List resultList = results.all();
        for (Result result : resultList) {
            if (results.hasKeys()) {
                System.out.println(result.getKey());
            }
            if (!results.hasValues()) continue;
        }
        return element.getObjectValue();
    }

    public Object getValue(String key) throws Exception {
        try {
            return this.cache.get((Serializable)((Object)key)).getObjectValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Object getValue(String cacheName, String key) {
        if (logger.isInfoEnabled()) {
            logger.info("{}\u83b7\u53d6\u7f13\u5b58:{}", (Object)cacheName, (Object)key);
        }
        return this.cache.get((Serializable)((Object)key)).getObjectValue();
    }

    public boolean removeAllElment(String cacheName, String key) throws Exception {
        try {
            this.cache.removeAll();
            return true;
        }
        catch (Exception e) {
            throw new Exception("remove cache " + cacheName + " failed!!!");
        }
    }

    public void remove(String key) {
        this.cache.remove((Serializable)((Object)key));
    }

    public void removeAllKey() {
        this.cache.removeAll();
    }

    public List getKeys() {
        return this.cache.getKeys();
    }
}

