/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.bean;

import cn.smarthse.modules.platform.core.framework.utils.DateUtils;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.aliyun.oss.ClientException;
import com.aliyun.oss.HttpMethod;
import com.aliyun.oss.OSSClient;
import com.aliyun.oss.OSSException;
import com.aliyun.oss.model.GeneratePresignedUrlRequest;
import com.aliyun.oss.model.OSSObject;
import com.aliyun.oss.model.ObjectMetadata;
import com.aliyun.oss.model.PutObjectResult;
import com.aliyun.oss.model.ResponseHeaderOverrides;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.util.Date;
import org.apache.commons.fileupload.disk.DiskFileItem;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.commons.CommonsMultipartFile;

public class OssClientBean {
    private Logger logger = LogManager.getLogger(this.getClass());
    private static final String FILE_NAME_POINT_STRING = ".";
    private String domain = "oss-cn-hangzhou.aliyuncs.com";
    private String endpoint = "http://" + this.domain;
    private String accessKeyId = "YfPv24tEsppP7xNC";
    private String accessKeySecret = "ZELBgec7xToUrZEo05EnHm9dxVWHoz";
    private String bucketName = "yanfa-oss-file";
    private boolean asynch = false;
    private int exptime = 7200;
    private OSSClient client = null;
    private boolean publicread = true;

    public String getUrl(String urlfile) {
        return this.getUrl(urlfile, null, this.exptime);
    }

    public String getUrl(String urlfile, String filename, int exptime) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("//").append(this.bucketName).append(FILE_NAME_POINT_STRING).append(this.domain).append("/").append(urlfile);
            if (StringUtils.isNotEmpty(filename)) {
                url.append("?response-content-disposition=attachment;filename=" + filename);
            }
            return url.toString();
        }
        Date exp = DateUtils.addSecond(new Date(), exptime);
        URL url = null;
        url = StringUtils.isEmpty((CharSequence)filename) ? this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET) : this.generatePresignedUrl(this.bucketName, filename, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    private URL generatePresignedUrl(String bucketName, String attachmentFilename, String key, Date expiration, HttpMethod method) throws ClientException {
        GeneratePresignedUrlRequest request = new GeneratePresignedUrlRequest(bucketName, key);
        request.setExpiration(expiration);
        request.setMethod(method);
        ResponseHeaderOverrides responseHeaders = new ResponseHeaderOverrides();
        responseHeaders.setContentDisposition("attachment;filename=\"" + attachmentFilename + "\"");
        request.setResponseHeaders(responseHeaders);
        return this.getClient().generatePresignedUrl(request);
    }

    public String getUrlBybucket(String bucket, String urlfile) {
        if (StringUtils.isEmpty((CharSequence)urlfile) || StringUtils.isEmpty((CharSequence)bucket)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        if (this.publicread) {
            StringBuffer url = new StringBuffer();
            url.append("http://").append(this.bucketName).append(FILE_NAME_POINT_STRING).append("oss-cn-hangzhou.aliyuncs.com").append("/").append(urlfile);
            return url.toString();
        }
        Date exp = DateUtils.addSecond(new Date(), this.exptime);
        URL url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String getThumbnail(String urlfile, String styleName) {
        if (StringUtils.isEmpty((CharSequence)urlfile)) {
            return "";
        }
        if (urlfile.indexOf("http://") >= 0 || urlfile.indexOf("https://") >= 0) {
            return urlfile;
        }
        URL url = null;
        Date exp = DateUtils.addSecond(new Date(), this.exptime);
        urlfile = urlfile + "@!" + styleName;
        url = this.getClient().generatePresignedUrl(this.bucketName, urlfile, exp, HttpMethod.GET);
        return url.toString();
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5) {
        return this.OSSPutObject(serviceFilename, file, serviceDir, fileFullname, contentMD5, null);
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, String fileFullname, String contentMD5, String contentType) {
        ObjectMetadata objectMeta = new ObjectMetadata();
        objectMeta.setContentLength(file.length());
        if (StringUtils.isNotEmpty(fileFullname)) {
            objectMeta.setContentDisposition("attachment;filename=" + fileFullname);
        }
        if (StringUtils.isNotEmpty(contentType)) {
            objectMeta.setContentType(contentType);
        }
        if (StringUtils.isNotEmpty(contentMD5)) {
            objectMeta.setContentMD5(contentMD5);
        }
        return this.OSSPutObject(serviceFilename, file, serviceDir, objectMeta);
    }

    public String OSSPutObject(String serviceFilename, File file, String serviceDir, ObjectMetadata objectMeta) {
        StringBuffer ossfile = new StringBuffer();
        try {
            FileInputStream input = new FileInputStream(file);
            PutObjectResult resultObject = this.getClient().putObject(this.bucketName, serviceDir + "/" + serviceFilename, (InputStream)input, objectMeta);
            ossfile.append(serviceDir).append("/").append(serviceFilename);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return "";
        }
        return ossfile.toString();
    }

    public String OSSPutObject(String key, MultipartFile multipartFile, String serviceName, String contentMD5) {
        CommonsMultipartFile commonsMultipartFile = (CommonsMultipartFile)multipartFile;
        DiskFileItem diskFileItem = (DiskFileItem)commonsMultipartFile.getFileItem();
        File file = diskFileItem.getStoreLocation();
        String fileSuffix = multipartFile.getOriginalFilename().substring(multipartFile.getOriginalFilename().lastIndexOf(FILE_NAME_POINT_STRING));
        return this.OSSPutObject(key + fileSuffix, file, serviceName, multipartFile.getOriginalFilename(), contentMD5);
    }

    public OSSObject downloadFile(String file) {
        OSSObject obj = null;
        try {
            obj = this.getClient().getObject(this.bucketName, file);
        }
        catch (OSSException oe) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + oe.getMessage());
        }
        catch (ClientException ce) {
            this.logger.error("\u963f\u91cc\u4e91\u8fde\u63a5\u5931\u8d25:" + ce.getMessage());
        }
        catch (NullPointerException n) {
            this.logger.error("\u963f\u91cc\u4e91\u6587\u4ef6\u83b7\u53d6\u5931\u8d25:" + n.getMessage());
        }
        return obj;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String downloadFile(String fileOssurl, String destFilePath, String fileName) throws IOException {
        OSSObject ossObject = this.downloadFile(fileOssurl);
        if (StringUtils.isEmpty((CharSequence)fileOssurl) || StringUtils.isEmpty((CharSequence)destFilePath) || ossObject == null || ossObject.getObjectContent() == null) {
            return fileName;
        }
        BufferedOutputStream bos = null;
        InputStream reader = null;
        String[] names = new String[]{fileName};
        File file = this.getNoRepeatDestFilePath(destFilePath, names);
        File parentFile = file.getParentFile();
        if (parentFile != null && !parentFile.mkdirs() && !parentFile.isDirectory()) {
            throw new IOException("\u76ee\u5f55\u521b\u5efa\u5931\u8d25");
        }
        try {
            bos = new BufferedOutputStream(new FileOutputStream(file));
            reader = ossObject.getObjectContent();
            int len = 2048;
            byte[] b = new byte[len];
            while ((len = reader.read(b)) > 0) {
                bos.write(b, 0, len);
            }
            bos.flush();
        }
        catch (FileNotFoundException e) {
            this.logger.error("\u6587\u4ef6\u672a\u627e\u5230:" + e.getMessage());
        }
        catch (IOException e) {
            this.logger.error("\u6587\u4ef6\u4e0b\u8f7d\u5931\u8d25\uff0c\u8f93\u5165\u8f93\u51fa\u9519\u8bef:" + e.getMessage());
        }
        finally {
            if (reader != null) {
                reader.close();
            }
            if (bos != null) {
                bos.close();
            }
        }
        return names[0];
    }

    private File getNoRepeatDestFilePath(String destFilePath, String[] fileName) {
        if (!destFilePath.endsWith(File.separator)) {
            destFilePath = destFilePath + File.separator;
        }
        String fileSuffix = "";
        String pointStr = FILE_NAME_POINT_STRING;
        int pointIndex = fileName[0].lastIndexOf(FILE_NAME_POINT_STRING);
        if (pointIndex > 0) {
            fileSuffix = fileName[0].substring(pointIndex + 1);
            fileName[0] = fileName[0].substring(0, pointIndex);
        } else {
            pointStr = "";
        }
        File file = new File(destFilePath + fileName[0] + pointStr + fileSuffix);
        int i = 1;
        while (file.exists()) {
            file = new File(destFilePath + fileName[0] + i + pointStr + fileSuffix);
            ++i;
        }
        fileName[0] = i > 1 ? fileName[0] + --i + pointStr + fileSuffix : fileName[0] + pointStr + fileSuffix;
        return file;
    }

    public ObjectMetadata getObjectMetadataByUrl(String url) {
        ObjectMetadata metadata = this.getClient().getObjectMetadata(this.bucketName, url);
        return metadata;
    }

    public InputStream getInputStreamByUrl(String fileUrl) throws IOException {
        InputStream reader = null;
        try {
            URL url = new URL(fileUrl);
            HttpURLConnection urlCon = (HttpURLConnection)url.openConnection();
            urlCon.setConnectTimeout(5000);
            urlCon.setReadTimeout(5000);
            reader = urlCon.getInputStream();
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
        return reader;
    }

    public String getHost() {
        return "http://" + this.bucketName + FILE_NAME_POINT_STRING + this.domain;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getAccessKeyId() {
        return this.accessKeyId;
    }

    public void setAccessKeyId(String accessKeyId) {
        this.accessKeyId = accessKeyId;
    }

    public String getAccessKeySecret() {
        return this.accessKeySecret;
    }

    public void setAccessKeySecret(String accessKeySecret) {
        this.accessKeySecret = accessKeySecret;
    }

    public String getBucketName() {
        return this.bucketName;
    }

    public void setBucketName(String bucketName) {
        this.bucketName = bucketName;
    }

    public boolean isAsynch() {
        return this.asynch;
    }

    public void setAsynch(boolean asynch) {
        this.asynch = asynch;
    }

    public OSSClient getClient() {
        if (this.client == null) {
            this.client = new OSSClient(this.endpoint, this.accessKeyId, this.accessKeySecret);
        }
        return this.client;
    }

    public int getExptime() {
        return this.exptime;
    }

    public void setExptime(int exptime) {
        this.exptime = exptime;
    }

    public boolean isPublicread() {
        return this.publicread;
    }

    public void setPublicread(boolean publicread) {
        this.publicread = publicread;
    }

    public String getDomain() {
        return this.domain;
    }

    public void setDomain(String domain) {
        this.domain = domain;
    }
}

