/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework;

import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.MissingResourceException;

public class Global {
    public static final String SUCCESS = "success";
    public static final String FAIL = "fail";
    public static final Byte ACTIVE_YES = 1;
    public static final Byte ACTIVE_NO = 0;
    public static final String SHOW = "1";
    public static final String HIDE = "0";
    public static final String YES = "1";
    public static final String NO = "0";
    public static final Boolean TRUE = true;
    public static final Boolean FALSE = false;
    public static final String characterEncoding = "utf-8";
    public static final String HASH_ALGORITHM = "SHA-1";
    public static final int HASH_INTERATIONS = 1024;
    public static final int SALT_SIZE = 8;
    private static Global global = new Global();
    private static Map<String, String> ctxPropertiesMap = Maps.newHashMap();

    public static Global getInstance() {
        return global;
    }

    public static Map<String, String> getPropertiesMap() {
        return ctxPropertiesMap;
    }

    public static String getString(String key) {
        try {
            String value = ctxPropertiesMap.get(key);
            return value;
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static String getString(String key, String defaultValue) {
        try {
            String value = ctxPropertiesMap.get(key);
            if (StringUtils.isEmpty((CharSequence)value)) {
                return defaultValue;
            }
            return value;
        }
        catch (MissingResourceException e) {
            return defaultValue;
        }
    }

    public static Integer getInt(String key) {
        String value = ctxPropertiesMap.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return null;
        }
        return Integer.parseInt(value);
    }

    public static int getInt(String key, int defaultValue) {
        String value = ctxPropertiesMap.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return Integer.parseInt(value);
    }

    public static long getLong(String keyName, long defaultValue) {
        String value = Global.getString(keyName);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        try {
            return Long.parseLong(value.trim());
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    public static boolean getBoolean(String key) {
        String value = ctxPropertiesMap.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return false;
        }
        return new Boolean(value.trim());
    }

    public static boolean getBoolean(String key, boolean defaultValue) {
        String value = ctxPropertiesMap.get(key);
        if (StringUtils.isEmpty((CharSequence)value)) {
            return defaultValue;
        }
        return new Boolean(value.trim());
    }
}

