/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.interceptor.repeatform;

import cn.smarthse.modules.platform.core.framework.database.persistence.ResponseData;
import cn.smarthse.modules.platform.core.framework.database.persistence.ResponseStateEnum;
import cn.smarthse.modules.platform.core.framework.interceptor.repeatform.RepeatUrlFormData;
import cn.smarthse.modules.platform.core.framework.mapper.JsonMapper;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.HashMap;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.method.HandlerMethod;
import org.springframework.web.servlet.handler.HandlerInterceptorAdapter;

public class RepeatUrlFormInterceptor
extends HandlerInterceptorAdapter {
    private Logger logger = LogManager.getLogger(((Object)((Object)this)).getClass());
    public static final String SESSION_KEY_REPEATFORMDATA = "webform_data";
    private static final String repeatText = JsonMapper.toJsonString(new ResponseData(ResponseStateEnum.warning, "\u91cd\u590d\u64cd\u4f5c\uff01"));

    public boolean preHandle(HttpServletRequest request, HttpServletResponse response, Object handler) throws Exception {
        if (handler instanceof HandlerMethod) {
            HandlerMethod handlerMethod = (HandlerMethod)handler;
            Method method = handlerMethod.getMethod();
            RepeatUrlFormData annotation = method.getAnnotation(RepeatUrlFormData.class);
            ResponseBody bodytype = method.getAnnotation(ResponseBody.class);
            if (annotation != null) {
                if (this.repeatDataValidator(request)) {
                    this.logger.error("\u7981\u6b62\u91cd\u590d\u63d0\u4ea4\u8868\u5355\uff01bodytype={}", (Object)bodytype);
                    if (bodytype != null) {
                        try {
                            response.reset();
                            response.setContentType("application/json");
                            response.setCharacterEncoding("utf-8");
                            response.getWriter().print(repeatText);
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                    return false;
                }
                return true;
            }
            return true;
        }
        return super.preHandle(request, response, handler);
    }

    public boolean repeatDataValidator(HttpServletRequest httpServletRequest) {
        String params = JsonMapper.toJsonString(httpServletRequest.getParameterMap());
        String url = httpServletRequest.getRequestURI();
        HashMap<String, String> map = new HashMap<String, String>();
        map.put(url, params);
        String nowUrlParams = ((Object)map).toString();
        Object preUrlParams = httpServletRequest.getSession().getAttribute(SESSION_KEY_REPEATFORMDATA);
        if (preUrlParams == null) {
            httpServletRequest.getSession().setAttribute(SESSION_KEY_REPEATFORMDATA, (Object)nowUrlParams);
            return false;
        }
        if (preUrlParams.toString().equals(nowUrlParams)) {
            return true;
        }
        httpServletRequest.getSession().setAttribute(SESSION_KEY_REPEATFORMDATA, (Object)nowUrlParams);
        return false;
    }
}

