/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.utils;

import cn.smarthse.modules.platform.core.framework.utils.StringUtils;

public class StringMixedUtil {
    public static boolean checkChineseName(String value, int length) {
        return value != null && !"".equals(value) && value.matches("^[\u4e00-\u9fa5]+{1}") && value.length() <= length;
    }

    public static String mixedName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        if (StringMixedUtil.checkChineseName(name, 99)) {
            return StringMixedUtil.mixed(name, 1, 0);
        }
        return StringMixedUtil.mixed(name, 1, 0);
    }

    public static boolean checkMobile(String value) {
        return value != null && !"".equals(value) && value.matches("^[1][0-9]+\\d{9}");
    }

    public static String mixedMobile(String mobile) {
        if (StringUtils.isEmpty((CharSequence)mobile)) {
            return null;
        }
        if (StringMixedUtil.checkMobile(mobile)) {
            return StringMixedUtil.mixed(mobile, 3, 4);
        }
        return StringMixedUtil.mixed(mobile, 3, 1);
    }

    public static boolean checkEmail(String value) {
        return value != null && !"".equals(value) && value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    }

    public static String mixedEmail(String email) {
        if (StringUtils.isEmpty((CharSequence)email)) {
            return null;
        }
        if (StringMixedUtil.checkEmail(email)) {
            Integer endLen = email.indexOf(64) + 1;
            if (email.length() >= 2 + endLen) {
                String start = StringUtils.left((String)email, (int)2);
                String end = StringUtils.right((String)email, (int)endLen);
                return start + "****" + end;
            }
            return email;
        }
        return StringMixedUtil.mixed(email, 2, 1);
    }

    public static boolean checkTel(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{4}-\\d{8}|\\d{4}-\\d{7}|\\d(3)-\\d(8)");
    }

    public static String mixedTelphone(String tel) {
        if (StringUtils.isEmpty((CharSequence)tel)) {
            return null;
        }
        if (StringMixedUtil.checkTel(tel)) {
            return StringMixedUtil.mixed(tel, 3, 6);
        }
        return StringMixedUtil.mixed(tel, 3, 1);
    }

    public static boolean checkIDCard(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{15}|\\d{18}|(^\\d{17}(\\d|X|x)$)");
    }

    public static String mixedIDCard(String idc) {
        if (StringUtils.isEmpty((CharSequence)idc)) {
            return null;
        }
        if (StringMixedUtil.checkIDCard(idc)) {
            return StringMixedUtil.mixed(idc, 5, 3);
        }
        return StringMixedUtil.mixed(idc, 5, 1);
    }

    public static String mixedRealName(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        String start = StringUtils.left((String)name, (int)1);
        if (name.length() > 2) {
            String end = StringUtils.right((String)name, (int)1);
            return start + "***" + end;
        }
        return start + "***";
    }

    public static String mixed(String val, int startLen, int endLen) {
        if (StringUtils.isEmpty((CharSequence)val)) {
            return null;
        }
        if (val.length() >= startLen + endLen) {
            String start = StringUtils.left((String)val, (int)startLen);
            String end = StringUtils.right((String)val, (int)endLen);
            return start + "***" + end;
        }
        return val;
    }

    public static void main(String[] args) {
        System.out.println("\u90ae\u7bb1\uff1a" + StringMixedUtil.mixedEmail("gf@163.com"));
        System.out.println("\u90ae\u7bb1\uff1a" + StringMixedUtil.mixedEmail("gbx@smarthse.cn"));
    }
}

