/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.service;

import cn.smarthse.modules.platform.core.framework.Global;
import cn.smarthse.modules.platform.core.framework.mybatis.AgentMapper;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Date;
import java.util.List;
import org.apache.ibatis.session.RowBounds;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.transaction.annotation.Transactional;
import tk.mybatis.mapper.entity.Example;

@Transactional(readOnly=true)
public abstract class BaseServiceImpl<D extends AgentMapper<T>, T>
implements IBaseService<T> {
    protected Logger logger = LogManager.getLogger(this.getClass());
    @Autowired(required=false)
    protected D dao;

    private String getMemoryCacheName() {
        String memoryCacheName = this.dao.getClass().getInterfaces()[0].getName();
        return memoryCacheName;
    }

    protected T getFromMemoryCache(Long id) {
        if (id == null) {
            return null;
        }
        String memoryCacheName = this.getMemoryCacheName();
        return null;
    }

    protected void putToMemoryCache(Long id, T t) {
        if (id == null || t == null) {
            return;
        }
        String memoryCacheName = this.getMemoryCacheName();
    }

    protected void delFromMemoryCache(Long id) {
        if (id == null) {
            return;
        }
        String memoryCacheName = this.getMemoryCacheName();
    }

    private Long getIdFromT(T entity) {
        Class<?> cls = entity.getClass();
        Object id = null;
        try {
            Method getId = cls.getDeclaredMethod("getId", new Class[0]);
            if (getId != null) {
                id = getId.invoke(entity, new Object[0]);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
        return (Long)id;
    }

    @Override
    public T getById(Long id) {
        if (id == null || id == 0L) {
            return null;
        }
        Object t = this.getFromMemoryCache(id);
        if (t == null) {
            t = this.dao.selectByPrimaryKey((Object)id);
            if (t == null) {
                return null;
            }
            this.putToMemoryCache(id, t);
        }
        return t;
    }

    public List<T> getListByExample(Example example) {
        return this.dao.selectByExample((Object)example);
    }

    public int getCountByExample(Example example) {
        return this.dao.selectCountByExample((Object)example);
    }

    private void setUpdateInfo(T entity, Long updateBy) {
        Class<?> cls = entity.getClass();
        try {
            Method setUpdateBy;
            Method setUpdateDate = cls.getDeclaredMethod("setUpdateDate", Date.class);
            if (setUpdateDate != null) {
                setUpdateDate.invoke(entity, new Date());
            }
            if (updateBy != null && (setUpdateBy = cls.getDeclaredMethod("setUpdateBy", Long.class)) != null) {
                setUpdateBy.invoke(entity, updateBy);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setIsValid(T entity, boolean bln) {
        Class<?> cls = entity.getClass();
        try {
            Method setIsValid = cls.getDeclaredMethod("setIsValid", Boolean.class);
            if (setIsValid != null) {
                setIsValid.invoke(entity, bln);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    private void setCreateInfo(T entity, Long createBy) {
        Class<?> cls = entity.getClass();
        try {
            Method setCreateBy;
            Method setCreateDate = cls.getDeclaredMethod("setCreateDate", Date.class);
            if (setCreateDate != null) {
                setCreateDate.invoke(entity, new Date());
            }
            this.setIsValid(entity, Global.TRUE);
            if (createBy != null && (setCreateBy = cls.getDeclaredMethod("setCreateBy", Long.class)) != null) {
                setCreateBy.invoke(entity, createBy);
            }
        }
        catch (NoSuchMethodException e) {
            e.printStackTrace();
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
        catch (IllegalAccessException e) {
            e.printStackTrace();
        }
        catch (IllegalArgumentException e) {
            e.printStackTrace();
        }
        catch (InvocationTargetException e) {
            e.printStackTrace();
        }
    }

    @Override
    @Transactional(readOnly=false)
    public T add(T entity) {
        this.dao.insertSelective(entity);
        return entity;
    }

    @Override
    @Transactional(readOnly=false)
    public T add(T entity, Long createBy) {
        this.setCreateInfo(entity, createBy);
        this.setUpdateInfo(entity, createBy);
        this.dao.insertSelective(entity);
        this.putToMemoryCache(this.getIdFromT(entity), entity);
        return entity;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer update(T entity) {
        int updateCount = this.dao.updateByPrimaryKeySelective(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer update(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer updateCount = this.dao.updateByPrimaryKeySelective(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer updateByPrimaryKey(T entity, Long updateBy) {
        this.setUpdateInfo(entity, updateBy);
        Integer updateCount = this.dao.updateByPrimaryKey(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
        return updateCount;
    }

    @Override
    @Transactional(readOnly=false)
    public Integer delete(T entity, Long deleteBy) {
        this.setUpdateInfo(entity, deleteBy);
        this.setIsValid(entity, Global.FALSE);
        int updateCount = this.dao.updateByPrimaryKeySelective(entity);
        Long id = this.getIdFromT(entity);
        this.delFromMemoryCache(id);
        return updateCount;
    }

    @Override
    public List<T> getListByIds(String ids) {
        return this.dao.selectByIds(ids);
    }

    protected T getOneByExample(Example example) {
        List list = this.dao.selectByExampleAndRowBounds((Object)example, new RowBounds(0, 1));
        if (list.size() > 0) {
            return (T)list.get(0);
        }
        return null;
    }
}

