/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.core.framework.encrypt;

import java.security.MessageDigest;

public class SHA1Util {
    public static String hash(byte[] bytes, byte[] salt, int hashIterations) {
        byte[] hashed = null;
        try {
            MessageDigest digest = MessageDigest.getInstance("SHA-1");
            if (salt != null) {
                digest.reset();
                digest.update(salt);
            }
            hashed = digest.digest(bytes);
            System.out.println(SHA1Util.bytesToHexString(hashed));
            int iterations = hashIterations - 1;
            for (int i = 0; i < iterations; ++i) {
                digest.reset();
                hashed = digest.digest(hashed);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return SHA1Util.bytesToHexString(hashed);
    }

    public static String bytesToHexString(byte[] src) {
        StringBuilder stringBuilder = new StringBuilder("");
        if (src == null || src.length <= 0) {
            return null;
        }
        for (int i = 0; i < src.length; ++i) {
            int v = src[i] & 0xFF;
            String hv = Integer.toHexString(v);
            if (hv.length() < 2) {
                stringBuilder.append(0);
            }
            stringBuilder.append(hv);
        }
        return stringBuilder.toString();
    }

    public static byte[] hexStringToBytes(String hexString) {
        if (hexString == null || hexString.equals("")) {
            return null;
        }
        hexString = hexString.toUpperCase();
        int length = hexString.length() / 2;
        char[] hexChars = hexString.toCharArray();
        byte[] d = new byte[length];
        for (int i = 0; i < length; ++i) {
            int pos = i * 2;
            d[i] = (byte)(SHA1Util.charToByte(hexChars[pos]) << 4 | SHA1Util.charToByte(hexChars[pos + 1]));
        }
        return d;
    }

    private static byte charToByte(char c) {
        return (byte)"0123456789ABCDEF".indexOf(c);
    }
}

