/**
 * 
 */
package cn.smarthse.modules.supervisebloc.provider;

import cn.smarthse.modules.supervisebloc.model.BlocCorpInviteModel;
import cn.smarthse.modules.supervisebloc.model.BlocCorpModel;
import cn.smarthse.modules.supervisebloc.model.BlocCorpUserModel;

/**
 * 《监管系统集团版 同步接口声明》
 * 
 * 
 * @Project:  platform-bloc-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年6月25日-上午11:53:33
 */
public interface ISuperviseBlocService {

	/**
	 * 注册开通集团版软件服务
	 * <li>运营后台调用发起：购买处理,试用处理
	 * <li>
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月25日-上午11:56:14
	 * @param corpmodel
	 * @return 大于0表示成功
	 */
	int registerBlocCorp(BlocCorpModel corpmodel);
	
	/**
	 * 更新集团企业基础信息
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月25日-上午11:55:22
	 * @param corpmodel
	 * @return 大于0表示成功
	 */
	int updateBlocCorp(BlocCorpModel corpmodel);
	
	/**
	 * 
	 * 
	 * @Comments:  <购买流程后调用， 同步企业信息>
	 * @author zhoulj(周利军) [1217102780@qq.com]
	 * @since 2018年7月16日-下午3:44:16
	 * @param pcid	对应平台的企业ID
	 * @return 大于0表示成功
	 */
	int sycCompanyInfo(Long pcid);
	
	/**
	 * 添加/更新集团软件用户信息
	 * <li>isManger = true 	新增超级管理员
	 * <li>isManger = false 新增普通管理员
	 * <li>isManger = null	无视权限(业务设定)
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月25日-上午11:55:54
	 * @param userModel
	 * @return 大于0表示成功
	 */
	int updateUserInfo(BlocCorpUserModel userModel);
	
	/**
	 * 删除集团软件用户
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月27日-上午9:39:10
	 * @param userModel
	 * @return 大于0表示成功
	 */
	int deleteUser(BlocCorpUserModel userModel);
	
	/**
	 * 处理集团邀请状态
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月27日-上午10:23:04
	 * @param inviteModel
	 * @return
	 */
	int processInvite(BlocCorpInviteModel inviteModel);

	/**
	 * 处理集团解除绑定
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月27日-下午4:28:33
	 * @param inviteModel
	 * @return
	 */
	int processRemoveInvite(BlocCorpInviteModel inviteModel);
	
	
}
