/**
 * 
 */
package cn.smarthse.modules.supervisebloc.platform;

import java.util.List;

import javax.cn.smarthse.modules.supervisebloc.exception.SuperviseBlocException;

import cn.smarthse.modules.supervisebloc.model.BlocCorpInviteModel;
import cn.smarthse.modules.supervisebloc.model.BlocCorpModel;
import cn.smarthse.modules.supervisebloc.model.SearchConditionByBlocCorpModel;

/**
 * 《平台提供集团版所需服务接口定义》
 * 
 * 
 * @Project:  platform-bloc-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年6月25日-下午1:59:09
 */
public interface IPlatformBlocService {

	/**
	 * 获取集团软件:子企业信息服务
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年7月5日-下午5:17:23
	 * @param blocCorpId
	 * @return
	 */
	BlocCorpModel getBlocCorpInfo(Long blocCorpId);
	
	/**
	 * 根据条件查询上级企业基本信息列表
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月25日-下午2:00:27	
	 * @param searchModel	搜索条件
	 * @return
	 */
	List<BlocCorpModel> seachBlocCorpList(SearchConditionByBlocCorpModel searchModel);
	
	/**
	 * 根据企业名+社会信用代码发起邀请申请
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年7月3日-下午2:41:41
	 * @param blocCorpId		当前集团Id(平台企业Id)
	 * @param corpName			邀请的企业名称
	 * @param corpCC			邀请的企业社会信用代码
	 * @return	>0	表示处理完成
	 * @exception SuperviseBlocException	业务异常类
	 */
	int applyInviteByNameAndCC(Long blocCorpId, String corpName, String corpCC) throws SuperviseBlocException;
	
	/**
	 * 向平台发起企业邀请
	 * cn.smarthse.modules.supervisebloc.model.BlocCorpInviteModel.blocCorpId
	 * cn.smarthse.modules.supervisebloc.model.BlocCorpInviteModel.blocInviteCorpId
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月27日-下午3:30:33
	 * @param inviteModel
	 * @return
	 */
	int applyInvite(BlocCorpInviteModel inviteModel) throws SuperviseBlocException;
	
	/**
	 * 向平台发起解除绑定
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年6月27日-下午4:28:33
	 * @param inviteModel
	 * @return
	 */
	int removeInvite(BlocCorpInviteModel inviteModel) throws SuperviseBlocException;
	
	
	/**
	 * 向平台发起删除所有邀请记录
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author gbx
	 * @since 2018-7-17
	 * @param inviteModel
	 * @return
	 */
	int delBlocInvite(BlocCorpInviteModel inviteModel) throws SuperviseBlocException;
	
	/**
	 * 变更用户所属的企业
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2018年7月19日-下午5:52:40
	 * @param corpSoftUserId 集团企业软件用户ID
	 * @param corpName 企业名称
	 * @return 
	 */
	int changeUserCorp(Long corpSoftUserId,String corpName) throws SuperviseBlocException;
	
}
