/**
 * 
 */
package cn.smarthse.modules.supervisebloc.model;

import java.io.Serializable;

import lombok.Data;

/**
 * 《集团版用户数据模型》
 * 
 * 
 * @Project:  platform-bloc-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年6月27日-上午9:27:27
 */
public @Data class BlocCorpUserModel implements Serializable {
	private static final long serialVersionUID = 735431856589477586L;

	/**
	 * 集团企业Id
	 */
	private Long blocCorpId;
	
	/**
	 * 平台企业ID
	 * <li>当用户属于子公司时,该字段是用户所属子企业Id
	 * <li>NULL 时用户不属于子企业,可能就是集团企业的管理员
	 */
	 private Long corpId;
	 
	/**
	 * 集团企业软件ID
	 */
	private Long corpSoftId;
	
	/**
	 * 平台用户Id
	 * <li>平台对应集团软件,该字段可能为重
	 */
	private Long userId;
	
	/**
	 * 集团企业软件用户ID
	 * <li>平台对应集团软件,该字段唯一
	 */
	private Long corpSoftUserId;
	
	/**
	 * 软件用户唯一标识号
	 */
	private String usertoken;
	
	/**
	 * 登录账号
	 */
	private String username;
	
	/**
	 * 登录密码(MD5(明文))
	 * <li>该字段仅在修改用户信息时传递,密码为NULL时,表示不变更现在账号的密码
	 */
	private String password;
	
	 /**
     * 用户姓名
     */
    private String fullname;
    
    /**
     * 联系电话
     */
    private String mobile;
    
    /**
     * 设定为管理员
     * 1、超级管理员
	 * 2、普通管理员
	 * 3、普通用户
	 * 0、权限不变
     */
    private Byte mangerType;
    
	
}
