/**
 * 
 */
package cn.smarthse.modules.supervisebloc.model;

import java.io.Serializable;
import java.util.Date;


import lombok.Data;

/**
 * 《集团版企业信息数据》
 * 
 * 
 * @Project:  platform-bloc-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年6月25日-下午1:41:39
 */
public @Data class BlocCorpModel implements Serializable {
	private static final long serialVersionUID = 2765123124569683868L;
	/**
     * 企业ID
     */
    private Long id;

    /**
     * 注册类型(1-企业注册,2-医疗机构注册,3-其他组织机构)
     * @see cn.smarthse.modules.platform.enums.corp.CorpAuthEnum
     */
    private Byte regType;
    
    /**
     * 注册类型名称
     */
    private String regTypeName;

    /**
     * 企业名称、医疗机构名称
     */
    private String fullname;

    /**
     * 企业简称
     */
    private String shortname;

    /**
     * 企业图标
     */
    private Long logoFileId;
    
	/**
	 * 企业图标地址
	 */
    private String logoFileUrl;
    
    /**
     * 企业编号串(社会统一信代码/登记号/组织代码)
     */
    private String corpCc;

    /**
     * 企业编号串扩展(社会统一信代码/登记号/组织代码)
     */
    private String corpCcExtend;
    
    /**
     * 联系电话
     */
    private String corpTel;

    /**
     * 所属行业
     */
    private Long corpType;

    /**
     * 所属行业名称
     */
    private String corpTypeName  ;
    
    /**
     * 企业邮箱
     */
    private String corpEmail;

    /**
     * 企业注册行政区域
     */
    private Long corpAreaId;
    
    /**
     * 企业注册行政区域全称
     */
    private String corpAreaName;

    /**
     * 通讯地址
     */
    private String corpAddress;

    /**
     * 申请人
     */
    private String corpApplyName;

    /**
     * 申请人手机号
     */
    private String corpApplyMobile;

    /**
     * 最后修改时间
     */
    private Date updateDate;

    /**
     * 审核结果(0-草稿,1-待审核,2-审核通过,3-审核不通过)
     * @see cn.smarthse.modules.platform.enums.corp.CorpAuthEnum
     */
    private Byte checkState;
    
    /**
     * 审核时间
     */
    private Date checkDate;
    

    /**
	 * 企业软件Id
	 */
	private Long corpSoftId;
	
	/**
	 * 企业软件版本Id
	 */
	private Long softVersionId;
	
	/**
	 * 企业软件版本名称
	 */
	private String softVersionName;
	
	/**
	 * 软件名称
	 */
	private String softName;
	
	/**
	 * 软件服务开始日期
	 */
	private Date sdate;
	
	/**
	 * 软件服务结束日期
	 */
	private Date edate;
	
	/**
	 * 套餐名
	 */
	private String comboName;
	
	/**
	 * 空间数(单位G)
	 */
	private int spaceTotal;
	
	/**
	 * 用户数(人)
	 */
	private int userTotal;
    
	/**
	 * 集团企业Id(关系)
	 */
	private Long corpBlocId;
	
	/**
	 * 是否允许发起邀请
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年7月4日-下午2:29:26
	 * @return
	 */
	public boolean canInvite() {
		//corpBlocId!=null 企业已在某集团中
		//corpSoftId==null	企业未拥有职业健康软件
		if(corpBlocId!=null || corpSoftId==null) {
			return false;
		}
		return true;
	}
	
	/**
	 * 查看邀请描述
	 * 
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2018年7月4日-下午2:37:02
	 * @return
	 */
	public String getCanInviteText() {
		//TODO 周利军
		return "";
	}


}
