/**
 * 
 */
package cn.smarthse.modules.supervisebloc.model;

import java.io.Serializable;
import java.util.List;

import lombok.Data;

/**
 * 《集团企业邀请结果Model》
 * 
 * 
 * @Project:  platform-bloc-facade
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2018年6月27日-上午10:03:58
 */
public @Data class BlocCorpInviteModel implements Serializable {
	private static final long serialVersionUID = -7689987626386448324L;
	
	/**
	 * 集团企业Id
	 */
	private Long blocCorpId;
	
	/**
	 * 发起邀请的企业id
	 */
	private Long inviteCorpId;
	
	/**
	 * 邀请的子企业Id
	 */
	private Long blocInviteCorpId;
	
	/**
	 * 邀请状态(0-草稿,1-待确认,2-同意,3-拒绝)
	 */
	private Byte blocInviteState;
	
	/**
	 * 邀请企业管理员列表
	 * <b>管理员列表是来自子企业软件管理员,需求中要求同步职业健康管理员做为集团软件某权限的用户(非超级管理员)
	 * <li>列表空数据,跳过处理
	 */
	private List<BlocCorpUserModel> userList;
}
