/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.platform.agent.util;

import cn.smarthse.modules.platform.agent.model.Payment;
import java.util.List;

public final class Balance {
    private List<Payment> paymentList;
    private Double resultScale;
    private StringBuffer resultText;

    public Balance(List<Payment> paymentList) {
        this.paymentList = paymentList;
        this.resultText = new StringBuffer();
        this.resultScale = 0.0;
    }

    public void run(int level, double oldbanlanceSaleTotal, double balanceSaleTotal) {
        this.resultScale = this.blance(level, oldbanlanceSaleTotal, balanceSaleTotal);
    }

    private double blance(int level, double oldbanlanceSaleTotal, double balanceSaleTotal) {
        if (oldbanlanceSaleTotal > this.paymentList.get(level).getPaymentOffset() && level + 1 < this.paymentList.size()) {
            return this.blance(level + 1, oldbanlanceSaleTotal, balanceSaleTotal);
        }
        double totalMoney = oldbanlanceSaleTotal + balanceSaleTotal;
        if (totalMoney > this.paymentList.get(level).getPaymentOffset() && level + 1 < this.paymentList.size()) {
            double thisScale = (this.paymentList.get(level).getPaymentOffset() - oldbanlanceSaleTotal) * this.paymentList.get(level).getPaymentScale();
            this.resultText.append("\u516c\u5f0f:(").append(this.paymentList.get(level).getPaymentOffset()).append(" - ").append(oldbanlanceSaleTotal).append(") * ").append(this.paymentList.get(level).getPaymentScale()).append(" = ").append(thisScale).append("\n");
            double otherScale = this.blance(level + 1, this.paymentList.get(level).getPaymentOffset(), totalMoney - this.paymentList.get(level).getPaymentOffset());
            return thisScale + otherScale;
        }
        double scale = balanceSaleTotal * this.paymentList.get(level).getPaymentScale();
        this.resultText.append("\u516c\u5f0f:").append(balanceSaleTotal).append(" * ").append(this.paymentList.get(level).getPaymentScale()).append(" = ").append(scale).append("\n");
        System.out.println(this.resultText.toString());
        return scale;
    }

    public long getResultScale() {
        return this.resultScale.longValue();
    }

    public String getResultText() {
        return this.resultText.toString();
    }

    public static void main(String[] args) {
    }
}

