/*
 * Decompiled with CFR 0.152.
 */
package cn.smarthse.modules.giian.sys.utils;

import com.alibaba.fastjson.JSONObject;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.smarthse.exception.ServiceException;
import org.apache.commons.beanutils.PropertyUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.beans.BeanUtils;

public class CommonUtil {
    private static String[] units = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341"};
    private static String[] cycles = new String[]{"\u96f6", "\u4e00", "\u4e8c", "\u4e09", "\u56db", "\u4e94", "\u516d", "\u4e03", "\u516b", "\u4e5d", "\u5341", "\u5341\u4e00", "\u5341\u4e8c"};

    public static String codemessage2json(String code, String message) {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("code", code);
        map.put("msg", message);
        return CommonUtil.getJsonResult(map);
    }

    public static String getJsonResult(Map<String, Object> map) {
        return JSONObject.toJSON(map).toString();
    }

    public static String int2ChineseNum(int num) {
        if (num > 11) {
            return String.valueOf(num);
        }
        return units[num];
    }

    public static String int2ChineseCycleName(int num) {
        if (num > 12) {
            return "\u7b2c" + String.valueOf(num) + "\u5468\u671f";
        }
        return "\u7b2c" + cycles[num] + "\u5468\u671f";
    }

    public static String b2mb(long filesize) {
        double r = 0.0;
        String sbyte = "";
        if (filesize > 0x10000000000L) {
            sbyte = "T";
            r = Math.round(filesize / 1024L / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x4B400000L) {
            sbyte = "G";
            r = Math.round(filesize / 1024L / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 0x100000L) {
            sbyte = "M";
            r = Math.round(filesize / 1024L / 1024L * 10L) / 10;
        } else if (filesize > 1024L) {
            sbyte = "K";
            r = Math.round(filesize / 1024L * 10L) / 10;
        } else {
            sbyte = "";
            r = filesize;
        }
        return r + sbyte;
    }

    public static long getInt1tomaxRandom(long max) {
        return Math.round(Math.random() * (double)(max - 10L) + 8.0);
    }

    public static List<String> getHtmlImages(String html) {
        String img = "";
        ArrayList<String> pics = new ArrayList<String>();
        String regEx_img = "<img.*src=(.*?)[^>]*?>";
        Pattern p_image = Pattern.compile(regEx_img, 2);
        Matcher m_image = p_image.matcher(html);
        while (m_image.find()) {
            img = img + "," + m_image.group();
            Matcher m = Pattern.compile("src=\"?(.*?)(\"|>|\\s+)").matcher(img);
            while (m.find()) {
                String url = m.group(1);
                url = url.replace("'", "");
                pics.add(url);
            }
        }
        return pics;
    }

    public static String getTextLen(String text, int len) {
        if (text == null || "".equals(text)) {
            return "";
        }
        text = text.replaceAll("\\&[a-zA-Z]{1,10};", "").replaceAll("<[^>]*>", "");
        if ((text = text.replaceAll("[(/>)<]", "")).length() >= len) {
            return text.substring(0, len - 1) + "...";
        }
        return text;
    }

    public static String delHTMLTag(String htmlStr) {
        String regEx_script = "<script[^>]*?>[\\s\\S]*?<\\/script>";
        String regEx_style = "<style[^>]*?>[\\s\\S]*?<\\/style>";
        String regEx_html = "<[^>]+>";
        Pattern p_script = Pattern.compile(regEx_script, 2);
        Matcher m_script = p_script.matcher(htmlStr);
        htmlStr = m_script.replaceAll("");
        Pattern p_style = Pattern.compile(regEx_style, 2);
        Matcher m_style = p_style.matcher(htmlStr);
        htmlStr = m_style.replaceAll("");
        Pattern p_html = Pattern.compile(regEx_html, 2);
        Matcher m_html = p_html.matcher(htmlStr);
        htmlStr = m_html.replaceAll("");
        return htmlStr.trim();
    }

    public static String local2url(String filePath, String firstIndex) {
        String webfilepath = "/" + filePath.substring(filePath.indexOf(firstIndex), filePath.length());
        try {
            webfilepath = webfilepath.replaceAll("\\\\", "/");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return webfilepath;
    }

    public static String getWebFullPath(HttpServletRequest request) {
        StringBuffer path = new StringBuffer();
        path.append(request.getScheme()).append("://").append(request.getServerName()).append(":").append(request.getServerPort()).append(request.getContextPath()).append("/");
        return path.toString();
    }

    public static String str2Sort(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        return StringUtils.join((Object[])ary, (String)",");
    }

    public static String str2Sort2(String sort) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        sort = sort.replaceAll(" ", ",").replaceAll("\\[", "").replaceAll("\\]", ",");
        Object[] ary = sort.split(",");
        Collator comp = Collator.getInstance(Locale.CHINESE);
        Arrays.sort(ary, comp);
        return StringUtils.join((Object[])ary, (String)",");
    }

    public static List<String> str2list(String str) {
        ArrayList<String> list = new ArrayList<String>();
        if (!StringUtils.isEmpty((String)str)) {
            String[] words;
            for (String word : words = str.split("\\s+|[\uff0c,]")) {
                if (StringUtils.isEmpty((String)word)) continue;
                list.add(word);
            }
        }
        return list;
    }

    public static String ary2str(String sort, String replacement) {
        if (sort == null || "".equals(sort.trim())) {
            return sort;
        }
        Object[] ary = sort.split(",");
        Arrays.sort(ary);
        StringBuffer result = new StringBuffer();
        for (Object item : ary) {
            if ("[]".equals(replacement)) {
                result.append("[").append((String)item).append("]");
                continue;
            }
            if ("{}".equals(replacement)) {
                result.append("{").append((String)item).append("}");
                continue;
            }
            if ("()".equals(replacement)) {
                result.append("(").append((String)item).append(")");
                continue;
            }
            if ("<>".equals(replacement)) {
                result.append("<").append((String)item).append(">");
                continue;
            }
            result.append((String)item).append(replacement);
        }
        return result.toString();
    }

    public static String[] removeRepeat(String[] arry) {
        List<String> strList = Arrays.asList(arry);
        HashSet<String> strSet = new HashSet<String>(strList);
        String[] newArray = new String[strSet.size()];
        Iterator ite = strSet.iterator();
        int i = 0;
        while (ite.hasNext()) {
            newArray[i] = (String)ite.next();
            ++i;
        }
        return newArray;
    }

    public static boolean checkEmail(String value) {
        return value != null && !"".equals(value) && value.matches("\\w+([-+.]\\w+)*@\\w+([-.]\\w+)*\\.\\w+([-.]\\w+)*");
    }

    public static boolean checkTel(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{4}-\\d{8}|\\d{4}-\\d{7}|\\d(3)-\\d(8)");
    }

    public static boolean checkMobile(String value) {
        return value != null && !"".equals(value) && value.matches("^[1][0-9]+\\d{9}");
    }

    public static boolean checkChineseName(String value, int length) {
        return value != null && !"".equals(value) && value.matches("^[\u4e00-\u9fa5]+{1}") && value.length() <= length;
    }

    public static boolean checkBlank(String value) {
        return value != null && !"".equals(value) && value.matches("^\\s*|\\s*{1}");
    }

    public static boolean checkHtmlTag(String value) {
        return value != null && !"".equals(value) && value.matches("<(\\S*?)[^>]*>.*?</\\1>|<.*? />");
    }

    public static boolean checkURL(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-z]+://[^\\s]*");
    }

    public static boolean checkIP(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}+\\.\\d{1,3}");
    }

    public static boolean checkID(String value) {
        return value != null && !"".equals(value) && value.matches("[a-zA-Z][a-zA-Z0-9_]{4,15}{1}");
    }

    public static boolean checkQQ(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9][0-9]{4,13}");
    }

    public static boolean checkPostCode(String value) {
        return value != null && !"".equals(value) && value.matches("[1-9]\\d{5}(?!\\d)");
    }

    public static boolean checkIDCard(String value) {
        return value != null && !"".equals(value) && value.matches("\\d{15}|\\d{18}|(^\\d{17}(\\d|X|x)$)");
    }

    public static boolean checkLength(String value, int length) {
        return (value == null || "".equals(value.trim()) ? 0 : value.length()) <= length;
    }

    public static boolean checkNull(String value) {
        return value == null || "".equals(value.trim());
    }

    public static void forceUpdatable(Object dest, String[] fieldNames) throws IllegalAccessException, InvocationTargetException {
        if (fieldNames != null && fieldNames.length > 0) {
            CommonUtil.forceUpdatable(dest, Arrays.asList(fieldNames));
        }
    }

    public static void forceUpdatable(Object dest, List<String> fieldNames) throws IllegalAccessException, InvocationTargetException {
        if (fieldNames != null && fieldNames.size() > 0) {
            for (String fieldName : fieldNames) {
                org.apache.commons.beanutils.BeanUtils.copyProperty((Object)dest, (String)(fieldName + "Updable"), (Object)true);
            }
        }
    }

    public static void forceUpdatableIgnore(Object obj, List<String> ignoreNames) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        if (ignoreNames != null && ignoreNames.size() > 0) {
            for (int i = 0; i < ignoreNames.size(); ++i) {
                ignoreNames.set(i, ignoreNames.get(i) + "Updable");
            }
        }
        Field[] fields = obj.getClass().getDeclaredFields();
        for (int i = 0; i < fields.length; ++i) {
            String name = fields[i].getName();
            if (!name.endsWith("Updable") || fields[i].getType() != Boolean.class || ignoreNames.contains(name)) continue;
            PropertyUtils.setProperty((Object)obj, (String)name, (Object)true);
        }
    }

    public static void forceUpdatableIgnore(Object obj, String[] ignoreNames) throws IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        List<String> list = new ArrayList<String>();
        if (ignoreNames != null && ignoreNames.length > 0) {
            list = Arrays.asList(ignoreNames);
        }
        CommonUtil.forceUpdatableIgnore(obj, list);
    }

    public static List<String> urlFormat(String url) {
        ArrayList<String> list = new ArrayList<String>();
        Pattern pattern = Pattern.compile("\\{([^\\}]+)\\}");
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String t = matcher.group(1);
            list.add(t);
        }
        return list;
    }

    public static String urlReplace(String url, String paramName, String keyvalue) {
        String fullurl = url;
        List<String> list = CommonUtil.urlFormat(url);
        for (String s : list) {
            if (!s.equals(paramName)) continue;
            fullurl = url.replace("{" + paramName + "}", keyvalue);
        }
        return fullurl;
    }

    public static boolean listIsEmpty(List list) {
        return list == null || list.isEmpty();
    }

    public static boolean listIsNotEmpty(List list) {
        return !CommonUtil.listIsEmpty(list);
    }

    public static void main(String[] args) {
        System.out.println(CommonUtil.checkIDCard("33032419870202546X"));
    }

    public static void checkEmptyFields(Object javaBean, String ... propertyNames) throws ServiceException {
        for (String fieldName : propertyNames) {
            PropertyDescriptor propertyDescriptor = BeanUtils.getPropertyDescriptor(javaBean.getClass(), (String)fieldName);
            Object result = null;
            try {
                result = propertyDescriptor.getReadMethod().invoke(javaBean, new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
            if (result == null) {
                System.out.println(fieldName + "-\u4e0d\u80fd\u4e3a\u7a7a");
                throw new ServiceException("\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u5e76\u8865\u5145\u5b8c\u6574\uff01");
            }
            if (!(result instanceof String) || ((String)result).length() != 0) continue;
            System.out.println(fieldName + "-\u4e0d\u80fd\u4e3a\u7a7a");
            throw new ServiceException("\u6709\u5fc5\u586b\u9879\u672a\u586b\u5199\uff0c\u8bf7\u68c0\u67e5\u5e76\u8865\u5145\u5b8c\u6574\uff01");
        }
    }
}

