package cn.smarthse.modules.giian.sys.service.sys;

import java.util.List;

import cn.smarthse.modules.giian.sys.entity.sys.UserThirdlogin;

/**
 * 
 * 放射检测-app端账号登录情况service(存在GMS数据库)
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年7月1日 上午10:20:50
 */
public interface IUserThirdloginService {

	/**
	 * 后台操作-退出/登录(将登入状态isLogin为置0未登录)
	 * 
	 * @author liaoly
	 * @date 2021年6月30日 上午9:19:12
	 * @param uid : 将要退出登录的账号id
	 * @param isLogin : 放射检测账号-登录状态设置（1：登录；0：退出）
	 * @param adminId : 操作账号id
	 *  void
	 */
	void logoutApp(Integer uid, Integer isLogin, Integer adminId);
	
	/**
	 * 查询所有pad端(放射检测人员)账号的登录情况(数据不会很多 && 数据在另外一个数据，故这里一次性查询出来)
	 * 
	 * @author liaoly
	 * @date 2021年7月1日 上午11:32:38
	 * @return List<UserThirdlogin>
	 */
	List<UserThirdlogin> getAllUserThirdloginList();
	
	/**
	 * 查询所有pad端(放射检测人员)账号的登录情况(数据不会很多 && 数据在另外一个数据，故这里一次性查询出来)
	 * 
	 * @author liaoly
	 * @date 2021年7月1日 上午11:32:38
	 * @param uid : 账号id
	 * @return UserThirdlogin
	 */
	UserThirdlogin getUserThirdlogin(Integer uid);

}
