package cn.smarthse.modules.giian.sys.service.sys;

import java.io.IOException;
import java.util.Date;
import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.giian.sys.entity.sys.SysUser;
import cn.smarthse.modules.giian.sys.model.sys.SysRoleModuleModel;
import cn.smarthse.modules.giian.sys.model.sys.SysUserImportModel;
import cn.smarthse.modules.giian.sys.model.sys.SysUserModel;
import cn.smarthse.modules.giian.sys.model.sys.SysUserSearchModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 建安信息化系统：账号service
 * 
 * @Author liaoly
 * @Date 2020年9月1日 上午11:28:38
 */
public interface ISysUserService extends IBaseService<SysUser>{

	/**
	 * @Description
	 * @Author Wuxq
	 * @Date 10:20 2020/12/2
	 * @Param [username]
	 * @return cn.smarthse.modules.giian.sys.entity.sys.SysUser
	 **/
	SysUser getById(Integer id);

	/**
	 * 根据username/tel/model 读取用户Id
	 *
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年2月18日-下午2:53:35
	 * @param username
	 * @return
	 */
	Integer getUserId(String username);

	/**
	 * 根据username/tel 读取用户实体
	 *
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年2月18日-下午2:54:18
	 * @param username
	 *            用户名/tel
	 * @return
	 */
	SysUser getUser(String username);

	/**
	 * 根据username 读取用户实体
	 *
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年2月18日-下午2:54:18
	 * @param username
	 * @return
	 */
	SysUser getUserByUsername(String username);

	/**
	 * 根据tel 读取用户实体
	 *
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年2月18日-下午2:54:18
	 * @param tel
	 *            联系电话（手机号码）
	 * @return
	 */
	SysUser getUserByTel(String tel);

	/**
	 *
	 * ISysUserService.java
	 *
	 * @Description: 根据工号 读取用户实体
	 */
	SysUser getUserByStaffNo(String staffNo);

	/**
	 * 根据用户Id 读取用户角色编码列表
	 *
	 * @param userId
	 * @return
	 */
	List<String> getUserRoleList(Integer userId);

	/**
	 * 根据用户Id 读取用户角色名称列表
	 * @param userId : 账号id
	 * @return
	 */
	List<String> getUserRoleNameList(Integer userId);

	/**
	 * 根据用户Id读取用户权限编码列表
	 *
	 * @param userId
	 * @return
	 */
	List<String> getUserPermissionList(Integer userId);

	/**
	 * 根据用户Id读取用户权限名称列表
	 * @param userId : 账号id
	 * @return
	 */
	List<String> getUserPermissionNameList(Integer userId);
	
	/**
	 * 根据user_id查询所有角色各模块的数据范围(roleId为空时，返回null)
	 * @author liaoly
	 * @date 2021年1月13日 下午3:07:53
	 * @param userId : userId
	 * @return List<SysRoleModule>
	 */
	List<SysRoleModuleModel> getSysRoleModuleListByUserId(Integer userId);

	/**
	 *
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年2月19日-下午2:00:04
	 * @param params
	 * @param searchModel
	 * @return
	 */
	PageInfo<SysUserModel> getUserList(SysUserSearchModel searchModel);

	/**
	 * searchModel搜索用户列表
	 *
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年3月18日-下午3:37:09
	 * @param searchModel
	 * @return
	 */
	List<SysUser> getUserListBySearchModel(SysUserSearchModel searchModel);

	/**
	 * 获取所有技术人员列表
	 *
	 * @Comments: <对此方法的描述，可以引用系统设计中的描述>
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2019年4月25日-上午11:02:16
	 * @param cid
	 * @return
	 */
	List<SysUser> getAllSkillUser(Integer cid);

	/**
	 * @Comments: 获取所有技术人人员的id列表
	 * @author horsy(何世壹) [hsy@smarthse.cn]
	 * @since 2019年4月26日-下午5:25:40
	 * @param cid
	 * @return
	 */
	List<Integer> getAllSkillUserIds(Integer cid);

	/**
	 * TODO 蔡剑英 : 危险接口
	 *
	 * @Function: ISysUserService.java
	 * @Description: 仅做测试用例使用
	 */
	@Deprecated
	List<SysUser> getList();

	/**
	 * 查询所有用户 app端使用 根据最后获取
	 *
	 * @param lastSyncDate
	 *            用户名或者姓名
	 */
	public List<SysUser> getAllUserByLastSyncDate(Date lastSyncDate);

	/**
	 * @Description  查找某公司某部门的全部用户
	 * @Author Wuxq
	 * @Date 16:13 2020/12/1
	 * @Param [deptId, cid]
	 * @return java.util.List<cn.smarthse.modules.giian.sys.entity.sys.SysUser>
	 **/
	List<SysUser> getListByDeptIdAndCid(Integer deptId, Integer cid);

	/**
	 * @Description  按身份证获取信息,若有多个user的有效记录，抛出异常
	 * @Author Wuxq
	 * @Date 16:13 2020/12/1
	 * @Param [idCard]
	 * @return cn.smarthse.modules.giian.sys.entity.sys.SysUser
	 **/
	SysUser getByIdCard(String idCard);

	/**
	 * @Description  校验系统中用户A的身份证是否被其他用户使用
	 * @Author Wuxq
	 * @Date 16:12 2020/12/1
	 * @Param [idCard, userId]
	 * @return java.lang.Boolean
	 **/
	Boolean hasOthersByIdCard(String idCard, Integer userId);

	/**
	 * @Description  校验工号是否被其他人使用
	 * @Author Wuxq
	 * @Date 16:12 2020/12/1
	 * @Param [staffNo, userId]
	 * @return java.lang.Boolean
	 **/
	Boolean hasOthersByStaffNo(String staffNo, Integer userId);

	/**
	 * 校验用户名是否存在
	 */
	Boolean isUsernameExist(String username);

	/**
	 * 校验身份证号在系统中是否存在
	 */
	Boolean isIdCardExist(String idCard);

	/**
	 * @Description  校验手机号在系统中是否存在
	 * @Author Wuxq
	 * @Date 16:10 2020/12/1
	 * @Param [mobile, userId]
	 * @return java.lang.Boolean
	 **/
	Boolean isMobileExist(String mobile, Integer userId);

	/**
	 * @Description  验证系统中工号是否重复
	 * @Author Wuxq
	 * @Date 16:09 2020/12/1
	 * @Param [staffNo]
	 * @return java.lang.Boolean
	 **/
	Boolean isStaffNoExist(String staffNo);

	/**
	 * @Description  系统管理-用户管理-导入
	 * @Author Wuxq
	 * @Date 16:08 2020/12/1
	 * @Param [createBy, userList]
	 * @return void
	 **/
	void addByBatch(Integer createBy, List<SysUser> userList);

	/**
	 * @Description  系统管理-用户管理-新增用户
	 * @Author Wuxq
	 * @Date 16:08 2020/12/1
	 * @Param [user, createBy]
	 * @return cn.smarthse.modules.giian.sys.entity.sys.SysUser
	 **/
	SysUser addUser(SysUser user, Integer createBy);

	/**
	 * @Description  系统管理-用户管理-编辑提交
	 * @Author Wuxq
	 * @Date 16:07 2020/12/1
	 * @Param [user, updateBy]
	 * @return void
	 **/
	void editUser(SysUser user, Integer updateBy);

	/**
	 * @Description  删除用户: 1.删除角色用户关系表记录 2.删除用户主表
	 * @Author Wuxq
	 * @Date 16:07 2020/12/1
	 * @Param [id, updateBy]
	 * @return void
	 **/
	void delSysUser(Integer id, Integer updateBy);

	/**
	 * @Description  批量删除用户
	 * @Author Wuxq
	 * @Date 16:06 2020/12/1
	 * @Param [userIds, updateBy]
	 * @return void
	 **/
	void delByBatch(String userIds, Integer updateBy);

	/**
	 * @Description  批量更新
	 * @Author Wuxq
	 * @Date 16:06 2020/12/1
	 * @Param [userList, updateBy]
	 * @return void
	 **/
	void updateByBatch(SysUser[] userList, Integer updateBy);

	/**
	 *
	 * @Description: 导入最后一步 插入或更新数据
	 *
	 * @param: coverList
	 *             需覆盖系统中数据的list 走update方法 successList 通过导入验证的有效数据 走add方法
	 * @author: cjy
	 * @date: 2019年3月12日 下午4:52:18
	 */
	void processImportUserList(SysUser[] coverList, List<SysUser> successList, Integer updateBy);

	/**
	 * 修改密码
	 */
	public int changePassword(Integer currentAccountId,String oldPassword,String newPassword);

	/**
	 * @Description  重置密码，密码为：giian123456
	 * @Author Wuxq
	 * @Date 15:19 2020/12/2
	 * @Param [uid, updateBy]
	 * @return int
	 **/
	public int resetPassword(Integer uid ,Integer updateBy);
	
	/**
	 * 根据手机号重置密码
	 * @author liaoly
	 * @date 2020年12月9日 下午2:28:38
	 * @param mobile : 手机号
	 * @param password : 新密码(不带盐值的md5的密文)
	 * @return int 成功返回1，失败返回-1
	 */
	public int resetPassword(String mobile ,String password);

	/**
	 * @Description  单表查询结果转化成model
	 * @Author Wuxq
	 * @Date 15:19 2020/12/2
	 * @Param [user]
	 * @return cn.smarthse.modules.giian.sys.model.sys.SysUserModel
	 **/
	public SysUserModel toUserModel(SysUser user);

	/**
	 * @Description  用户名 已存在 末尾添加数字顺延
	 * @Author Wuxq
	 * @Date 15:19 2020/12/2
	 * @Param [username, suffix]
	 * @return java.lang.String
	 **/
	public String getNewUsername(String username, Integer suffix);

	/**
	 * @Description  导入检验，从Excel文件获取集合对象及错误信息
	 * @Author Wuxq
	 * @Date 15:34 2020/12/9
	 * @Param [fileId, adminId]
	 * @return cn.smarthse.modules.giian.sys.model.sys.SysUserImportModel
	 **/
	SysUserImportModel importUser(Long fileId, Integer adminId) throws IOException;

	/**
	 * @Description  保存导入
	 * @Author Wuxq
	 * @Date 15:35 2020/12/9
	 * @Param [sysUserImportModel, accountId]
	 * @return void
	 **/
	void saveImportUser(SysUserImportModel sysUserImportModel, Integer accountId);

	/**
	 * @Description  根据手机号进行身份认证
	 * @Author Wuxq
	 * @Date 11:08 2020/12/10
	 * @Param [mobile, idCard]
	 * @return void
	 **/
	int authentication(Integer currentId, String mobile, String idCard);

	/**
	 * @Description  查询 业务主管 和 业务员 角色的用户
	 * @Author Wuxq
	 * @Date 13:59 2020/12/10
	 * @Param
	 * @return
	 **/
	public List<SysUser> getBusinessUserList();
}
