package cn.smarthse.modules.giian.sys.service.sys;

import java.util.List;

import cn.smarthse.modules.giian.sys.entity.sys.SysUserRole;
import cn.smarthse.modules.giian.sys.model.sys.SysRoleModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 建安信息化系统：用户-角色关系service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月25日 下午4:13:53
 */
public interface ISysUserRoleService extends IBaseService<SysUserRole>{

	/**
	 * @Description  按用户Id查出角色
	 * @Author Wuxq
	 * @Date 16:24 2020/12/2
	 * @Param [userId]
	 * @return java.util.List<cn.smarthse.modules.giian.sys.entity.sys.SysUserRole>
	 **/
	List<SysUserRole> getListByUserId(Integer userId);

	/**
	 * @Description  按用户Id和角色查SysUserRole表
	 * @Author Wuxq
	 * @Date 16:24 2020/12/2
	 * @Param [userId, roleId]
	 * @return cn.smarthse.modules.giian.sys.entity.sys.SysUserRole
	 **/
	SysUserRole getByUserIdAndRole(Integer userId,Integer roleId);

	/**
	 * @Description  找出拥有业务类型角色的uid
	 * @Author Wuxq
	 * @Date 16:24 2020/12/2
	 * @Param []
	 * @return java.util.List<cn.smarthse.modules.giian.sys.entity.sys.SysUserRole>
	 **/
	List<SysUserRole> getUidListByBusinessType();

	/**
	 *
	 * @Function: ISysUserRoleService.java
	 * @Description: 根据用户ID批量删除
	 *
	 * @param:描述1描述
	 * @return：返回结果描述
	 * @throws：异常描述
	 *
	 * @version: v1.0.0
	 * @author: cjy
	 * @date: 2019年2月21日 下午4:24:23
	 *
	 * Modification History:
	 * Date         Author          Version            Description
	 *---------------------------------------------------------*
	 * 2019年2月21日      cjy           v1.0.0               修改原因
	 */
	void delByUserId(Integer userId,Integer updateBy);

	/**
	 * 判断用户是否包含roleIds角色(多个)
	 *
	 * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
	 * @author JannyShao(邵建义) [ksgameboy@qq.com]
	 * @since 2019年3月18日-下午3:06:09
	 * @param userId
	 * @param roleIds
	 * @return
	 */
	boolean checkUserRole(Integer userId, String roleIds);
	
	/**
	 * 角色列表可选项(当前账号的)
	 * @author liaoly
	 * @date 2020年11月13日 上午10:13:13
	 * @param adminId : 当前账号id
	 * @return List<SysRoleModel>
	 */
	public List<SysRoleModel> getRoleList_choose(Long adminId);

	/**
	 * @Description  根据 roleId 删除
	 * @Author Wuxq
	 * @Date 8:48 2020/12/8
	 * @Param [roleId, updateBy]
	 * @return void
	 **/
	void deleteSysUserRoleByRoleId(Integer roleId,Integer updateBy);

	/**
	 * @Description  根据userId判断是不是超级管理员
	 * @Author Wuxq
	 * @Date 10:39 2020/12/18
	 * @Param
	 * @return
	 **/
	boolean ifSuperAdmin(Integer userId);

	/**
	 * 判断指定角色是否有用户
	 * @author liaoly
	 * @date 2021年1月14日 下午1:23:37
	 * @param roleId : 角色id
	 * @return boolean 有用户则返回true，没有则返回false
	 */
	boolean hasUserRole(Integer roleId);
}
