
package cn.smarthse.modules.giian.sys.service.sys;

import java.util.List;

import cn.smarthse.modules.giian.sys.entity.sys.SysRoleModule;
import cn.smarthse.modules.giian.sys.model.sys.SysRoleModuleModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 
 * 角色模块的数据范围表service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月13日 下午2:34:40
 */
public interface ISysRoleModuleService extends IBaseService<SysRoleModule>{

	/**
	 * 根据角色id查询角色各模块的数据范围(roleId为空时，返回null)
	 * @author liaoly
	 * @date 2021年1月13日 下午3:07:53
	 * @param roleId : 角色id
	 * @return List<SysRoleModule>
	 */
	List<SysRoleModuleModel> getSysRoleModuleListByRoleId(Integer roleId);
	
	/**
	 * 根据角色id查询角色各模块的数据范围(roleId为空时，返回null)
	 * @author liaoly
	 * @date 2021年1月13日 下午3:07:53
	 * @param userId : userId
	 * @return List<SysRoleModule>
	 */
	List<SysRoleModuleModel> getSysRoleModuleListByUserId(Integer userId);

	/**
	 * 添加or更新
	 * @author liaoly
	 * @date 2021年1月19日 下午1:57:42
	 * @param dataScopeList
	 * @param currentAccountId void
	 */
	void saveSysRoleModule(List<SysRoleModule> dataScopeList, Integer currentAccountId);

	/**
	 * 对象转换
	 * @author liaoly
	 * @date 2021年1月19日 下午2:13:41
	 * @param roleId : 角色id
	 * @param module : 模块类型 (ModuleEnum为准)
	 * @param dataScope : 数据范围(DataScopeEnum为准)
	 * @return SysRoleModule
	 */
	SysRoleModule toggleToSysRoleModule(Integer roleId, Integer module, String dataScope);

	/**
	 * 对象转换
	 * 
	 * @author liaoly
	 * @date 2021年1月19日 下午2:14:52
	 * @param roleId : 角色id
	 * @param dataScopeList : 数据范围集合(DataScopeEnum为准，正常情况下集合大小应为7)
	 * @return List<SysRoleModule>
	 */
	List<SysRoleModule> toggleToSysRoleModule(Integer roleId, List<String> dataScopeList);
}
