package cn.smarthse.modules.giian.sys.service.sys;

import java.util.List;
import java.util.Map;

import cn.smarthse.modules.giian.sys.entity.sys.SysMenu;
import cn.smarthse.modules.giian.sys.model.sys.SysMenuModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 
 * 建安信息化系统：权限
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月19日 下午4:15:12
 */
public interface ISysMenuService extends IBaseService<SysMenu>{

	/**
	 * 查询所有的权限列表(排除掉系统模块的)
	 * @author liaoly
	 * @date 2020年11月19日 下午4:14:55
	 * @return List<SysMenuModel>
	 */
	List<SysMenuModel> getAllMenuModelList();

	/**
	 * @Description  角色权限的菜单数据 :  roleId==null时为新增角色时的权限菜单数据，反之为编辑时的权限菜单数据
	 * @Author Wuxq
	 * @Date 14:42 2020/12/3
	 * @Param [roleId]
	 * @return java.util.Map<java.lang.Integer,java.util.List<cn.smarthse.modules.giian.sys.entity.sys.SysMenu>>
	 **/
	Map<Integer, List<SysMenuModel>> getRolePermissionList(Integer roleId);

	/**
	 * @Description  查询 parentId = 0 的所有父级 菜单
	 * @Author Wuxq
	 * @Date 10:12 2020/12/7
	 * @Param
	 * @return
	 **/
	List<SysMenuModel> getSysMenuListByParentId (Integer id);


}
