package cn.smarthse.modules.giian.sys.service.sys;

import cn.smarthse.modules.giian.sys.entity.sys.Department;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

import java.util.List;

/**
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8>
 * @author <开发者>
 * @since 2020-12-01 10:14
 */
public interface IDepartmentService extends IBaseService<Department> {
    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 按部门父ID查找
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月21日 上午8:21:27
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月21日      cjy           v1.0.0               修改原因
     */
    List<Department> getListByDeptPid(Integer pid);

    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 查询该公司下的全部部门
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月21日 下午3:19:31
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月21日      cjy           v1.0.0               修改原因
     */
    List<Department> getListByCid(Integer cid);

    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 找到根节点(即部门)对应的表记录
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月22日 上午10:24:20
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月22日      cjy           v1.0.0               修改原因
     */
    Department getRootByCid(Integer cid);

    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 按部门名称查询部门表
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月22日 下午2:36:33
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月22日      cjy           v1.0.0               修改原因
     */
    Department getByDeptName(String deptName,Integer cid);

    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 部门名称模糊查询
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年3月13日 下午4:08:11
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年3月13日      cjy           v1.0.0               修改原因
     */
    List<Department> getLikeDeptName(String deptName,Integer cid);
    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 判断部门ID是否是父节点
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月21日 上午9:03:02
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月21日      cjy           v1.0.0               修改原因
     */
    Boolean isParent(Integer deptId);

    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 检验某个部门是否存在
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月21日 下午2:04:16
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月21日      cjy           v1.0.0               修改原因
     */
    Boolean isDeptExists(String deptName);

    /**
     *
     * @Function: IDepartmentService.java
     * @Description: 删除当前部门,若有子部门，将子部门删除
     *
     * @param:描述1描述
     * @return：返回结果描述
     * @throws：异常描述
     *
     * @version: v1.0.0
     * @author: cjy
     * @date: 2019年2月27日 下午3:42:09
     *
     * Modification History:
     * Date         Author          Version            Description
     *---------------------------------------------------------*
     * 2019年2月27日      cjy           v1.0.0               修改原因
     */
    void delDept(Integer deptId,Integer userId);


    /**
     * 获取业务部门
     *
     * @Comments:  <对此方法的描述，可以引用系统设计中的描述>
     * @author JannyShao(邵建义) [ksgameboy@qq.com]
     * @since 2019年7月24日-上午8:44:44
     * @param cid		企业编号
     * @param roleType	cn.smarthse.business.entity.system.SysRole.roleType 角色类型:0:待确定1.业务员2.其他。后续扩展
     * @return
     */
    List<Department> getBusinessDept(Integer cid, Integer roleType);

    /**
     * @Description  获取部门名称（存在相同名称则追加数字）
     * @Author Wuxq
     * @Date 9:02 2020/12/3
     * @Param [deptName, suffix]
     * @return java.lang.String
     **/
    String getNewDeptname(String deptName, Integer suffix);

    /**
     * @Description  
     * @Author Wuxq
     * @Date 17:08 2020/12/8
     * @Param [deptId]
     * @return cn.smarthse.modules.giian.sys.entity.sys.Department
     **/
    Department getDepartmentById(Integer deptId);


    List<String> treeDepartmentIdList(Integer pid,List<String> ids);


}
