package cn.smarthse.modules.giian.sys.provider;


/**
 *  短信服务
 *
 * @author  wuxq
 * @date    2021/6/4
 */
public interface ISmsProvider {

    /**
     * 方法描述:  通用接口发文本短信
     *
     * @param   vcode 验证码
     * @param   mobile 手机号码
     * @return  String
     * @author  wuxq
     * @date    2021/6/4
     */
    boolean sendVcode(String vcode, String mobile);

    /**
     * 方法描述:  群发文本短信
     *
     * @param   vcode 验证码
     * @param   mobiles 手机号码，多个以 , 隔开
     * @return  String 1：成功
     * @author  wuxq
     * @date    2021/6/4
     */
    void sendVcodeBatch(String vcode, String mobiles);

}
