package cn.smarthse.modules.giian.sys.model.sys;

import java.io.Serializable;
import java.util.List;

import cn.smarthse.modules.giian.sys.entity.sys.SysUser;
import cn.smarthse.modules.giian.sys.entity.sys.SysUserRole;
import cn.smarthse.modules.platform.core.framework.utils.StringMixedUtil;
import cn.smarthse.modules.platform.core.framework.utils.StringUtils;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 建安信息化系统：用户
 * 
 * @Author liaoly
 * @Date 2020年9月3日 上午9:08:13
 */
public @Data class SysUserModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@ApiModelProperty(value="ID")
	private Integer id;
	/**
	 * 用户名
	 */
	@ApiModelProperty(value="用户名")
	private String userName;
/*	*//**
	 * 密码
	 *//*
	@ApiModelProperty(value="密码",hidden = true)
	private String passWord;*/
	/**
	 * 姓名
	 */
	@ApiModelProperty(value="姓名")
	private String realName;
	/**
	 * 性别
	 */
	@ApiModelProperty(value="性别",hidden = true)
	private String sex;
	/**
	 * 部门Id
	 */
	@ApiModelProperty(value="部门ID")
	private Integer deptId;
	/**
	 * 部门名称
	 */
	@ApiModelProperty(value="部门名称",hidden = true)
	private String deptName;
	/**
	 * 职位
	 */
	@ApiModelProperty(value="职位")
	private String position;
	/**
	 * 工号
	 */
	@ApiModelProperty(value="工号")
	private String staffNo;
	/**
	 * 企业id
	 */
	@ApiModelProperty(value="企业id",hidden = true)
	private Integer cid;
	/**
	 * 联系电话（手机号码）
	 */
	@ApiModelProperty(value="联系电话（手机号码）")
	private String mobile;
	/**
	 * 身份证号
	 */
	@ApiModelProperty(value="身份证号")
	private String idCard;
	/**
	 * 进入部门时间
	 */
	@ApiModelProperty(value="进入部门时间",hidden = true)
	private java.util.Date deptJoinDate;
	/**
	 * 岗位状态:1-在岗、2-离岗
	 *
	 */
	@ApiModelProperty(value="岗位状态:1在岗或者2离岗")
	private Integer dutyState;
	private String dutyStateStr;
	/**
	 * 职位
	 */
	@ApiModelProperty(value="头像url",hidden = true)
	private String faceUrl;
	/**
	 * 创建时间
	 */
	@ApiModelProperty(value="创建时间",hidden = true)
	private java.util.Date createTime;
	/**
	 * 更新时间
	 */
	@ApiModelProperty(value="更新时间",hidden = true)
	private java.util.Date updateTime;



	@ApiModelProperty(value="身份认证标识")
	private Boolean authenticationFlag = false;
	/**
	 * 用户角色id列表
	 * 角色说明
	 */
	@ApiModelProperty(value="角色Ids")
	private String roleIds;
	
	@ApiModelProperty(value="放射检测账号-登录状态（1：登录状态；0：未登入状态）")
	private Integer isLogin;

	@ApiModelProperty(value="用户角色列表",hidden = true)
	private List<SysUserRole> userRoleList;

	@ApiModelProperty(value="用户角色名称,仅做显示",hidden = true)
	private String roleNames;

	@ApiModelProperty(value="销售区域ID",hidden = true)
	private String salesAreaIds;

	@ApiModelProperty(value="当前登录的账号是否有编辑当前账号的权限")
	private Boolean hasPermission = false;

	public SysUserModel(SysUser user) {
		if(user==null) return ;

		this.id = user.getId();
		this.userName = user.getUserName();
		this.realName = user.getRealName();
		this.idCard = StringMixedUtil.mixedIDCard(user.getIdCard() == null ? "" : user.getIdCard());
		this.mobile = user.getMobile()==null ? "": user.getMobile();
		this.faceUrl = user.getFaceUrl() == null ? "" : user.getFaceUrl();
		this.position = user.getPosition()== null ? "" : user.getPosition();
		this.staffNo = user.getStaffNo()==null ? "" : user.getStaffNo();
		this.deptName = user.getDeptName() == null ? "" : user.getDeptName();
		this.deptId = user.getDeptId();
		this.dutyState = user.getDutyState();
		this.cid = user.getCid();
		this.updateTime = user.getUpdateTime();
		this.createTime = user.getCreateTime();
		this.deptJoinDate = user.getDeptJoinDate();
		this.authenticationFlag = StringUtils.isNotEmpty(user.getIdCard());
	}
	/**
	 *
	 */
	public SysUserModel() {
	}

}
