package cn.smarthse.modules.giian.sys.model.sys;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

import cn.smarthse.modules.giian.sys.entity.sys.SysRole;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 建安信息化系统：角色
 * 
 * @Author liaoly
 * @Date 2020年9月3日 上午9:09:29
 */
public @Data class SysRoleModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 键值uuid_short
	 */
    @ApiModelProperty(value="id")
	private Integer id;
	/**
	 * 角色名称
	 */
    @ApiModelProperty(value="角色名称")
	private String roleName;
	/**
	 * 角色英文名称(编码)
	 */
    @ApiModelProperty(value="角色英文名称(编码)")
	private String roleCode;
	/**
	 * 备注描述
	 */
	@ApiModelProperty(value="备注描述")
	private String roleDesc;
	/**
	 * 是否系统角色(1-是，0-否）
	 */
    @ApiModelProperty(value="是否系统角色(1-是，0-否）")
	private Boolean isSys;
	/**
	 * 数据范围(部门id集合，全公司则存所有部门id，个人为0)
	 */
	@ApiModelProperty(value="数据范围(部门id集合，全公司则存所有部门id，个人为0)")
	@Deprecated
	private String dataScope;
	@ApiModelProperty (value = "数据范围（多部门名称）",hidden = true)
	@Deprecated
	private String dataScopeName;
	@ApiModelProperty (value = "数据范围是否多选")
	@Deprecated
	private Boolean isMultiple;
	
	@ApiModelProperty (value = "各个模块的数据范围")
	private List<SysRoleModuleModel> sysRoleModuleList;
	/**
	 * 对应系统名称(0：所有系统；1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理；7：业务管理)
	 */
	@ApiModelProperty(value="对应系统名称")
	private String module;
	/**
	 * 是否有效
	 */
    @ApiModelProperty(value="是否有效",hidden = true)
	private Boolean isValid;
	/**
	 * 创建者
	 */
    @ApiModelProperty(value="创建者",hidden = true)
	private Integer createBy;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间",hidden = true)
	private java.util.Date createTime;
	/**
	 * 更新者
	 */
    @ApiModelProperty(value="更新者",hidden = true)
	private Integer updateBy;
	/**
	 * 更新时间
	 */
    @ApiModelProperty(value="更新时间",hidden = true)
	private java.util.Date updateTime;

    @ApiModelProperty(value="角色权限列表")
	Map<Integer,List<SysMenuModel>> sysMenuModelListMap;

	public SysRoleModel(){};

	public SysRoleModel(SysRole role) {
		if (role == null)
			return;
		this.id = role.getId();
		this.roleName = role.getRoleName();
		this.isSys = role.getIsSys();
		this.roleDesc = role.getRoleDesc();
		//this.deptId = role.getDeptId();
		this.dataScope = role.getDataScope();
		this.module = role.getModule();
		this.createBy = role.getCreateBy();
	}
}
