package cn.smarthse.modules.giian.sys.model.login;

import java.util.ArrayList;
import java.util.List;

import cn.smarthse.modules.giian.sys.enums.sys.DataScopeEnum;
import cn.smarthse.modules.giian.sys.enums.sys.ModuleEnum;
import lombok.Data;

/**
 * 指定module的若干角色中最大范围的"数据范围"
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月15日 下午1:40:46
 */
public @Data class UserDataScopeModel {
	
	/**
	 * 当前登入账号id
	 */
	private Integer userId;
	
	/**
	 * 当前登入账号部门id
	 */
	private Integer deptId;
	
	/**
	 * 模块
	 */
	private ModuleEnum moduleEnum;
	
	/**
	 * 数据范围
	 */
	private DataScopeEnum dataScopeEnum ;
	
	/**
	 * 数据范围
	 */
	private String dataScope ;
	
	/**
	 * SCPOE_DEPTS 多部门时，具体部门id集合
	 */
	private List<Integer> deptIdList = new ArrayList<Integer>();
	
	public UserDataScopeModel() {
		
	}
	
	public UserDataScopeModel(Integer userId, Integer deptId, ModuleEnum moduleEnum) {
		super();
		this.userId = userId;
		this.deptId = deptId;
		this.moduleEnum = moduleEnum;
	}
	
	public void setDataScopeEnum(DataScopeEnum dataScopeEnum) {
		this.dataScopeEnum = dataScopeEnum;
		this.dataScope = dataScopeEnum.getValue();
	}
}
