package cn.smarthse.modules.giian.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 《部门类型名称》
 * @Project:  GiianSystem
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年2月18日-下午2:02:48
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DepartmentTypeEnum {

	//1：业务部门；2：业务管理；技术部门；4：其他部门；

	TYPE_ONE("业务部门", 1),
	TYPE_TWO("业务管理", 2),
	TYPE_THREE("技术部门", 3),
	TYPE_FOUR("其他部门", 4),
	;
	// 成员变量
	private String name;
	private Integer state;
	// 构造方法

	private DepartmentTypeEnum(String name, Integer state) {
		this.name = name;
		this.state = state;
	}
	
	// 普通方法
	public static String getName(Integer state) {
		if (state == null) {
			return null;
		}
		for (DepartmentTypeEnum c : values()) {
			if (c.getState().equals(state)) {
				return c.name;
			}
		}
		return null;
	}
			
			
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}
	
	
	
}
