package cn.smarthse.modules.giian.sys.enums.sys;

import com.fasterxml.jackson.annotation.JsonFormat;

/**
 * 数据范围
 * 	（全公司1000000，多部门：部门id拼接字符串，以英文“,”分隔，本部门999999，个人为0)
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月11日 上午11:24:48
 */
@JsonFormat(shape = JsonFormat.Shape.OBJECT)
public enum DataScopeEnum {

	SCPOE_ALL_COMPANY("全公司", "1000000"),
	
	SCPOE_DEPTS("多部门", "1"),
	
	SCPOE_DEPT("本部门", "999999"),
	
	SCPOE_PERSONAL("个人", "0"),
	;
	
	private String name;
	
	private String value;

	private DataScopeEnum(String name, String value) {
		this.name = name;
		this.value = value;
	}
	
	public static String getName(String value) {
		if (value == null) {
			return null;
		}
		for (DataScopeEnum c : values()) {
			if (c.getValue().equals(value)) {
				return c.name;
			}
		}
		return null;
	}
			
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}
}