package cn.smarthse.modules.giian.sys.entity.sys;

import java.io.Serializable;

import javax.persistence.*;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 建安信息化系统：用户
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月25日 下午4:11:09
 */
@Table(name = "sys_user")
public @Data class SysUser implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 *
	 */
	@Id
	@Column(name = "ID")
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;
	/**
	 * 账号
	 */
	@ApiModelProperty(value="用户名")
	private String userName;
	/**
	 * 密码
	 */
	@ApiModelProperty(value="密码",hidden = true)
	private String passWord;
	/**
	 * 盐值
	 */
	@ApiModelProperty(value="盐值",hidden = true)
	private String salt;
	/**
	 * 姓名
	 */
	@ApiModelProperty(value="姓名")
	private String realName;
	/**
	 * 工号
	 */
	@ApiModelProperty(value="工号")
	private String staffNo;
	/**
	 * 企业id
	 */
	@ApiModelProperty(value="企业id",hidden = true)
	private Integer cid;
	/**
	 * 身份证号
	 */
	@ApiModelProperty(value="身份证号")
	private String idCard;
	/**
	 * 部门Id
	 */
	@ApiModelProperty(value="部门id")
	private Integer deptId;
	/**
	 * 进入部门时间
	 */
	@ApiModelProperty(value="入部时间",hidden = true)
	private java.util.Date deptJoinDate;
	/**
	 * 性别
	 */
	@ApiModelProperty(value="性别（男女）")
	private String sex;
	/**
	 * 手机
	 */
	@ApiModelProperty(value="手机号")
	private String mobile;
	/**
	 * 职位
	 */
	@ApiModelProperty(value="职位")
	private String position;
	/**
	 * 岗位状态:1-在岗、2-离岗
	 */
	@ApiModelProperty(value="岗位状态：1-在岗、2-离岗")
	private Integer dutyState;
	/**
	 * 头像url
	 */
	private String faceUrl;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
	@ApiModelProperty(value="是否有效",hidden = true)
	private Boolean isValid;
	/**
	 * 是否禁用
	 */
	@ApiModelProperty(value="是否禁用",hidden = true)
	private Boolean isForbidden;
	/**
	 * 创建人
	 */
	@ApiModelProperty(value="创建人",hidden = true)
	private Integer createBy;
	/**
	 * 创建时间
	 */
	@ApiModelProperty(value="创建时间",hidden = true)
	private java.util.Date createTime;
	/**
	 * 最后修改人ID
	 */
	@ApiModelProperty(value="最后修改人ID",hidden = true)
	private Integer updateBy;
	/**
	 * 最后修改时间
	 */
	@ApiModelProperty(value="最后修改时间",hidden = true)
	private java.util.Date updateTime;

	/**
	 * 角色ID串
	 */
	@ApiModelProperty(value="角色ids，用 , 分隔")
	@Transient
	private String roleIds;

	/**
	 * 角色名称串
	 */
	@ApiModelProperty(value="角色名称串",hidden = true)
	@Transient
	private String roleName;

	/**
	 * 所在部门
	 */
	@ApiModelProperty(value="所在部门",hidden = true)
	@Transient
	private String deptName;
}
