
package cn.smarthse.modules.giian.sys.entity.sys;

import java.io.Serializable;

import javax.persistence.*;

import lombok.Data;

/**
 * 角色模块的数据范围表
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2021年1月13日 下午2:31:27
 */
@Table(name = "sys_role_module")
public @Data class SysRoleModule implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 
	 */
    @Id
    @Column(name = "ID")
	@GeneratedValue(strategy = GenerationType.IDENTITY)
	private Integer id;
	/**
	 * 角色id
	 */
	private Integer roleId;
	/**
	 * 模块类型(1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理)
	 */
	private Integer module;
	/**
	 * 数据范围：（全公司1000000，多部门：部门id拼接字符串，以英文,分隔本部门999999，个人为0)
	 */
	private String dataScope;
	/**
	 * 创建人账号id
	 */
	private Integer createBy;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 更新人账号id
	 */
	private Integer updateBy;
	/**
	 * 更新时间
	 */
	private java.util.Date updateDate;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
	private Integer isValid;
}
