package cn.smarthse.modules.giian.sys.vo.sys;

import java.util.Date;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 日志查询参数类
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月3日 上午8:28:15
 */
public @Data class LogQueryParam {
	
	@ApiModelProperty("当前页码")
	private Integer pageNum = 1;
	
	@ApiModelProperty("每页数量")
	private Integer pageSize = 10;
	
	@ApiModelProperty("模糊匹配关键字")
	private String keyword;
	
	@ApiModelProperty("模块(首页; 关于建安; 业务领域; 信息公示; 人才理念; 其它管理; 系统管理; 登入)")
	private String module;
	
	@ApiModelProperty("操作账号")
	private String username;

	@ApiModelProperty("日志类型(1-登录类型，0-操作类型）")
	private Integer logType;
	
	@ApiModelProperty("时间段筛选-开始时间")
	private Date beginDate;
	
	@ApiModelProperty("时间段筛选-结束时间")
	private Date endDate;
}
