package cn.smarthse.modules.giian.sys.service.sys;

import java.util.List;

import cn.smarthse.modules.giian.sys.entity.sys.SysRole;
import cn.smarthse.modules.giian.sys.entity.sys.SysUserRole;
import cn.smarthse.modules.giian.sys.model.sys.SysRoleModel;
import cn.smarthse.modules.giian.sys.model.sys.SysRoleSearchModel;
import cn.smarthse.modules.giian.sys.vo.sys.AddRoleForm;
import cn.smarthse.modules.platform.core.framework.jqgrid.JqGridParam;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import com.github.pagehelper.PageInfo;

/**
 * 建安信息化系统：角色service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月2日 下午12:26:02
 */
public interface ISysRoleService extends IBaseService<SysRole>{

	/**
	 * 获取全部角色
	 */
	List<SysRole> getTotal();

	/**
	 * 找出业务类型的角色id
	 */
	List<SysRole> getByRoleType(Integer roleType);

	/**
	 * @Description  通过角色名获取角色
	 * @Author Wuxq
	 * @Date 10:55 2020/12/2
	 * @Param [deptId, roleName]
	 * @return cn.smarthse.modules.giian.sys.entity.sys.SysRole
	 **/
	SysRole getByRoleName(Integer deptId, String roleName);

	/**
	 * @Description  角色List集合
	 * @Author Wuxq
	 * @Date 10:56 2020/12/2
	 * @Param [model]
	 * @return java.util.List<cn.smarthse.modules.giian.sys.entity.sys.SysRole>
	 **/
	List<SysRole> searchRoleList(SysRoleSearchModel model);

	/**
	 * @Description  角色列表分页数据
	 * @Author Wuxq
	 * @Date 10:57 2020/12/2
	 * @Param [params, model]
	 * @return com.github.pagehelper.PageInfo<cn.smarthse.modules.giian.sys.model.sys.SysRoleModel>
	 **/
	PageInfo<SysRoleModel> getPageRoleList(SysRoleSearchModel model);

	/**
	 * @Description  新增角色
	 * @Author Wuxq
	 * @Date 10:45 2020/12/4
	 * @Param [addRoleForm, currentAccountId]
	 * @return void
	 **/
    void addRole(AddRoleForm addRoleForm, Integer currentAccountId);

    /**
     * @Description  新增角色
     * @Author Wuxq
     * @Date 13:17 2020/12/4
     * @Param [sysRole, currentAccountId]
     * @return cn.smarthse.modules.giian.sys.entity.sys.SysRole
     **/
	SysRole addRole(SysRole sysRole, Integer currentAccountId);

	/**
	 * @Description 根据id获取角色详情
	 * @Author Wuxq
	 * @Date 15:18 2020/12/7
	 * @Param [roleId]
	 * @return cn.smarthse.modules.giian.sys.model.sys.SysRoleModel
	 **/
	SysRoleModel getRoleModel(Integer roleId);

	/**
	 * @Description  根据id删除角色
	 * @Author Wuxq
	 * @Date 17:53 2020/12/7
	 * @Param [roleId]
	 * @return void
	 **/
	void deleteRole(Integer roleId , Long currentAccountId);
}
