package cn.smarthse.modules.giian.sys.service.sys;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.giian.sys.entity.sys.SysLog;
import cn.smarthse.modules.giian.sys.vo.sys.LogQueryParam;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 建安信息化系统：操作日志service
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年10月23日 下午4:16:11
 */
public interface ISysLogService extends IBaseService<SysLog>{
	 
	/**
	 * 查询操作日志记录
	 * 
	 * @author liaoly
	 * @date 2020年11月3日 上午8:34:01
	 * @param logQueryParam : 综合查询参数对象
	 * @return List<SysLog>
	 */
	List<SysLog> getSysLogList(LogQueryParam logQueryParam);

	/**
	 * 查询操作日志记录(分页)
	 * @author liaoly
	 * @date 2020年11月3日 上午8:47:49
	 * @param logQueryParam : 综合查询参数对象
	 * @return PageInfo<SysLog>
	 */
	PageInfo<SysLog> getSysLogListData(LogQueryParam logQueryParam);
}
