package cn.smarthse.modules.giian.sys.model.sys;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
import lombok.EqualsAndHashCode;

import java.io.Serializable;

/**
 * 角色-权限关系
 * 
 * @Author liaoly
 * @Date 2020年9月3日 上午9:08:43
 */
@EqualsAndHashCode(callSuper=false)
public @Data class SysRolePermissionModel extends SysMenuModel implements Serializable{
	
	private static final long serialVersionUID = 1L;
	/**
	 * ID
	 */
    @ApiModelProperty(value="ID")
	private Integer id;
	/**
	 * 角色编号
	 */
    @ApiModelProperty(value="角色编号")
	private Integer roleId;
	/**
	 * 角色名称（冗余）
	 */
	@ApiModelProperty(value="角色名称（冗余）")
	private String roleName;
	/**
	 * 菜单编号
	 */
    @ApiModelProperty(value="菜单id")
	private Integer menuId;
	/**
	 * 权限编码
	 */
	@ApiModelProperty(value="权限编码")
	private String permissionCode;
	/**
	 * 权限名称
	 */
	@ApiModelProperty(value="权限名称")
	private String permissionName;
	/**
	 * 是否有效
	 */
    @ApiModelProperty(value="是否有效")
	private Boolean isValid;
	/**
	 * 创建者
	 */
    @ApiModelProperty(value="创建者")
	private Integer createBy;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间")
	private java.util.Date createTime;
	/**
	 * 更新者
	 */
    @ApiModelProperty(value="更新者")
	private Integer updateBy;
	/**
	 * 更新时间
	 */
    @ApiModelProperty(value="更新时间")
	private java.util.Date updateTime;


}
