package cn.smarthse.modules.giian.sys.model.sys;

import java.io.Serializable;

import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 建安信息化系统：权限
 * 
 * @Author liaoly
 * @Date 2020年9月3日 上午9:09:01
 */
public @Data class SysMenuModel implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 键值uuid_short
	 */
    @ApiModelProperty(value="id")
	private Integer id;
	/**
	 * 父编号
	 */
    @ApiModelProperty(value="父编号")
	private Integer parentId;
	/**
	 * 权限编号
	 */
    @ApiModelProperty(value="权限编码")
	private String permissionCode;
	/**
	 * 名称
	 */
    @ApiModelProperty(value="名称")
	private String menuName;
	/**
	 * 模块类型(1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理)
	 */
	@ApiModelProperty(value="模块类型(1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理；7：业务管理)")
	private Integer module;
	/**
	 * 排序
	 */
    @ApiModelProperty(value="排序",hidden = true)
	private Integer orderBy;
	/**
	 * 连接地址
	 */
    @ApiModelProperty(value="连接地址",hidden = true)
	private String href;
	/**
	 * 目标窗口
	 */
    @ApiModelProperty(value="目标窗口",hidden = true)
	private String target;
	/**
	 * 模块图标
	 */
    @ApiModelProperty(value="模块图标",hidden = true)
	private String icon;
	/**
	 * 是否可见(1-是，0-隐藏）
	 */
    @ApiModelProperty(value="是否可见(1-是，0-隐藏）",hidden = true)
	private Boolean isShow;
	/**
	 * 是否有效
	 */
    @ApiModelProperty(value="是否有效",hidden = true)
	private Boolean isValid;
	/**
	 * 创建者
	 */
    @ApiModelProperty(value="创建者",hidden = true)
	private Integer createBy;
	/**
	 * 创建时间
	 */
    @ApiModelProperty(value="创建时间",hidden = true)
	private java.util.Date createTime;
	/**
	 * 更新者
	 */
    @ApiModelProperty(value="更新者",hidden = true)
	private Integer updateBy;
	/**
	 * 更新时间
	 */
    @ApiModelProperty(value="更新时间",hidden = true)
	private java.util.Date updateTime;

	/**
	 * sys_role_permission 中 对应的 menu_id
	 */
	@ApiModelProperty(value="角色权限勾选标识")
	private Integer permissionMenuId;

}
