package cn.smarthse.modules.giian.sys.enums.sys;

/**
 * 《系统模块名称》
 * @Project:  GiianSystem
 * @Module ID:   <(模块)类编号，可以引用系统设计中的类编号>
 * @Comments:  <对此类的描述，可以引用系统设计中的描述>
 * @JDK version used:      <JDK1.8> 
 * @author JannyShao(邵建义) [ksgameboy@qq.com]
 * @since 2019年2月18日-下午2:02:48
 */
public enum ModuleEnum {

	//对应系统名称(0：所有系统；1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理；7：业务管理)

	ALL_SYSTEM("所有系统", 0),
	GIIAN_WEBSITE("建安官网后台", 1),
	PERSONAL_DOSE("个人剂量", 2),
	RADIATION_DETECTION("放射检测", 3),
	Instruments_WEBSITE("设备仪器管理", 4),
	CUSTOMER_MANAGE("客户管理", 5),
	SYSTEM_MANAGE("系统管理", 6),
	BUSINESS_MANAGE("业务管理", 6),
	;
	// 成员变量
	private String name;
	private Integer state;
	// 构造方法

	private ModuleEnum(String name, Integer state) {
		this.name = name;
		this.state = state;
	}
	
	// 普通方法
	public static String getName(Integer state) {
		if (state == null) {
			return null;
		}
		for (ModuleEnum c : values()) {
			if (c.getState().equals(state)) {
				return c.name;
			}
		}
		return null;
	}
			
			
	// get set 方法
	public String getName() {
		return name;
	}
	public void setName(String name) {
		this.name = name;
	}

	public Integer getState() {
		return state;
	}

	public void setState(Integer state) {
		this.state = state;
	}
	
	
	
}
