package cn.smarthse.modules.giian.sys.entity.sys;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * 建安信息化系统：角色
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月25日 下午4:10:32
 */
@Table(name = "sys_role")
public @Data class SysRole implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 键值uuid_short
	 */
    @Id
    @Column(name = "ID")
	private Integer id;
	/**
	 * 角色名称
	 */
	private String roleName;
	/**
	 * 角色英文名称(编码)
	 */
	private String roleCode;
	/**
	 * 备注描述
	 */
	private String roleDesc;
	/**
	 * 是否系统角色(1-是，0-否）
	 */
	private Boolean isSys;
	/**
	 * 数据范围(部门id集合，全公司则存所有部门id，个人为0)
	 */
	private String dataScope;
	/**
	 * 对应系统名称(0：所有系统；1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理；7：业务管理)
	 */
	private String module;
	/**
	 * 是否有效
	 */
	private Boolean isValid;
	/**
	 * 创建者
	 */
	private Integer createBy;
	/**
	 * 创建时间
	 */
	private java.util.Date createTime;
	/**
	 * 更新者
	 */
	private Integer updateBy;
	/**
	 * 更新时间
	 */
	private java.util.Date updateTime;


}
