package cn.smarthse.modules.giian.sys.entity.sys;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * 建安信息化系统：权限
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月25日 下午4:10:22
 */
@Table(name = "sys_menu")
public @Data class SysMenu implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * 键值uuid_short
	 */
    @Id
    @Column(name = "ID")
	private Integer id;
	/**
	 * 父编号
	 */
	private Integer parentId;
	/**
	 * 权限编号
	 */
	private String permissionCode;
	/**
	 * 名称
	 */
	private String menuName;
	/**
	 * 模块类型(1：建安官网后台；2：个人剂量；3放射检测；4：设备仪器管理；5：客户管理；6：系统管理)
	 */
	private Integer module;
	/**
	 * 排序
	 */
	private Integer orderBy;
	/**
	 * 连接地址
	 */
	private String href;
	/**
	 * 目标窗口
	 */
	private String target;
	/**
	 * 模块图标
	 */
	private String icon;
	/**
	 * 是否可见(1-是，0-隐藏）
	 */
	private Boolean isShow;
	/**
	 * 备注信息
	 */
	private String remarks;
	/**
	 * 是否有效
	 */
	private Boolean isValid;
	/**
	 * 创建者
	 */
	private Integer createBy;
	/**
	 * 创建时间
	 */
	private java.util.Date createTime;
	/**
	 * 更新者
	 */
	private Integer updateBy;
	/**
	 * 更新时间
	 */
	private java.util.Date updateTime;


}
