package cn.smarthse.modules.giian.sys.entity.sys;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.GeneratedValue;
import javax.persistence.GenerationType;
import javax.persistence.Id;
import javax.persistence.Table;

import lombok.Data;

/**
 * 建安信息化系统：操作日志
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年10月22日 下午4:37:15
 */
@Table(name = "sys_log")
public @Data class SysLog implements Serializable{
	private static final long serialVersionUID = 1L;
	/**
	 * ID
	 */
    @Id
    @Column(name = "ID")
    @GeneratedValue(strategy = GenerationType.IDENTITY, generator = "select uuid_short()")
	private Long id;
	/**
	 * 操作账号(冗余)
	 */
	private String username;
	/**
	 * 用户姓名(冗余)
	 */
	private String fullname;
	/**
	 * 日志标题
	 */
	private String title;
	/**
	 * 来源模块
	 */
	private String module;
	/**
	 * 类型(0-异常日志,1-登录日志,2-操作日志）
	 */
	private Byte type;
	/**
	 * 请求IP地址
	 */
	private String remoteIp;
	/**
	 * 用户代理信息
	 */
	private String userAgent;
	/**
	 * 请求URI
	 */
	private String requestUri;
	/**
	 * 操作方式、post/get/push等resetful
	 */
	private String requestMethod;
	/**
	 * 操作提交的数据内容(json)或者异常信息
	 */
	private String params;
	/**
	 * 创建人
	 */
	private Long createBy;
	/**
	 * 创建时间
	 */
	private java.util.Date createDate;
	/**
	 * 最后修改人ID
	 */
	private Long updateBy;
	/**
	 * 最后修改时间
	 */
	private java.util.Date updateDate;
	/**
	 * 是否有效（0-无效，1-有效）
	 */
	private Boolean isValid;


}
