
package cn.smarthse.modules.giian.service.talent;

import cn.smarthse.modules.giian.entity.talent.TalentRecruit;
import cn.smarthse.modules.giian.model.talent.TalentRecruitModel;
import cn.smarthse.modules.giian.model.talent.TalentRecruitQueryParam;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;
import com.github.pagehelper.PageInfo;

import java.util.List;

/**
 * 人才理念_招聘网站
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月6日 下午1:53:06
 */
public interface ITalentRecruitService extends IBaseService<TalentRecruit>{


    /**
     * @Author Wuxq
     * @Description //  查询（分页）
     * @Date 15:24 2020/11/9
     * @Param [queryParam]
     * @return com.github.pagehelper.PageInfo<cn.smarthse.modules.giian.model.talent.TalentRecruitModel>
     **/
    PageInfo<TalentRecruitModel> getTalentRecruitListData(TalentRecruitQueryParam queryParam);

    /**
     * @Author Wuxq
     * @Description //  查询
     * @Date 15:28 2020/11/9
     * @Param [queryParam]
     * @return java.util.List<cn.smarthse.modules.giian.model.talent.TalentRecruitModel>
     **/
    List<TalentRecruitModel> getTalentRecruitList(TalentRecruitQueryParam queryParam);

    /**
     * @Author Wuxq
     * @Description //  根据id查询
     * @Date 15:37 2020/11/9
     * @Param [id]
     * @return cn.smarthse.modules.giian.model.talent.TalentRecruitModel
     **/
    TalentRecruitModel getTalentRecruit(Long id);

    /**
     * @Author Wuxq
     * @Description // 新增
     * @Date 15:48 2020/11/9
     * @Param [talentRecruit]
     * @return cn.smarthse.modules.giian.model.talent.TalentRecruitModel
     **/
    TalentRecruitModel addTalentRecruit(TalentRecruitModel talentRecruit);


    /**
     * @Author Wuxq
     * @Description //  保存
     * @Date 15:56 2020/11/9
     * @Param [talentRecruit]
     * @return void
     **/
    void saveTalentRecruit(TalentRecruitModel talentRecruit);

    /**
     * @Author Wuxq
     * @Description //  删除
     * @Date 16:08 2020/11/9
     * @Param [id, adminName, adminId]
     * @return void
     **/
    void delTalentRecruit(Long id, String adminName, Long adminId);
    /**
     * @Author Wuxq
     * @Description //  批量删除
     * @Date 16:05 2020/11/9
     * @Param [idArr, adminName, adminId]
     * @return void
     **/
    void delTalentRecruit(Long[] idArr, String adminName, Long adminId);

    /**
     * @Author Wuxq
     * @Description //  更新状态
     * @Date 16:13 2020/11/9
     * @Param [talentRecruit]
     * @return void
     **/
    void saveStatus(TalentRecruit talentRecruit);

    /**
     * @Author Wuxq
     * @Description //   列表数据，www
     * @Date 16:26 2020/11/9
     * @Param []
     * @return java.util.List<cn.smarthse.modules.giian.model.talent.TalentConceptModel>
     **/
    List<TalentRecruitModel> getTalentRecruitList_www();
}
