
package cn.smarthse.modules.giian.service.talent;

import java.util.List;

import cn.smarthse.modules.giian.entity.talent.TalentConnect;
import cn.smarthse.modules.giian.model.talent.TalentConnectModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 人才理念_联系方式
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月6日 下午1:52:36
 */
public interface ITalentConnectService extends IBaseService<TalentConnect>{

	/**
	 * 查询联系方式
	 * @author liaoly
	 * @date 2020年11月9日 上午10:24:58
	 * @return List<TalentConnectModel>
	 */
	List<TalentConnectModel> getTalentConnectList();

	/**
	 * 查询联系方式详情
	 * @author liaoly
	 * @date 2020年11月9日 上午10:29:44
	 * @param id : TalentConnect.id
	 * @return TalentConnectModel
	 */
	TalentConnectModel getTalentConnect(Long id);

	/**
	 * 添加联系方式
	 * @author liaoly
	 * @date 2020年11月9日 上午10:35:30
	 * @param talentConnect : 参数对象
	 * @return TalentConceptModel
	 */
	TalentConnectModel addTalentConnect(TalentConnectModel talentConnect);

	/**
	 * 更新操作
	 * @author liaoly
	 * @date 2020年11月9日 上午10:39:35
	 * @param talentConnect : 参数对象
	 * void
	 */
	void saveTalentConnect(TalentConnectModel talentConnect);

	/**
	 * 删除联系方式
	 * @author liaoly
	 * @date 2020年11月9日 上午10:45:05
	 * @param id : TalentConnect.id
	 * @param adminName : 操作账号昵称
	 * @param adminId : 操作账号id
	 * void
	 */
	void delTalentConnect(Long id, String adminName, Long adminId);

	/**
	 * 查询联系方式(提供给www的,默认查询4条)
	 * @author liaoly
	 * @date 2020年11月9日 上午11:00:49
	 * @return List<TalentConnectModel>
	 */
	List<TalentConnectModel> getTalentConnectList_www();
}
