
package cn.smarthse.modules.giian.service.talent;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.giian.entity.talent.TalentConcept;
import cn.smarthse.modules.giian.model.talent.TalentConceptModel;
import cn.smarthse.modules.giian.model.talent.TalentConceptQueryParam;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 人才理念_人才理念
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月6日 下午1:52:54
 */
public interface ITalentConceptService extends IBaseService<TalentConcept>{

	/**
	 * 人才理念_人才理念 查询
	 * @author liaoly
	 * @date 2020年11月6日 下午2:32:24
	 * @param logQueryParam
	 * @return PageInfo<TalentConceptModel>
	 */
	List<TalentConceptModel> getTalentConceptList(TalentConceptQueryParam queryParam);
	
	/**
	 * 人才理念 查询(分页)
	 * @author liaoly
	 * @date 2020年11月6日 下午2:32:24
	 * @param logQueryParam
	 * @return PageInfo<TalentConceptModel>
	 */
	PageInfo<TalentConceptModel> getTalentConceptListData(TalentConceptQueryParam queryParam);
	
	/**
	 * 查询人才理念列表(提供给www的)
	 * @author liaoly
	 * @date 2020年11月6日 下午4:17:19
	 * @return PageInfo<TalentConceptModel>
	 */
	List<TalentConceptModel> getTalentConceptList_www();

	/**
	 * 查询 人才理念 详情
	 * @author liaoly
	 * @date 2020年11月6日 下午2:37:10
	 * @param id : TalentConcept.id
	 * @return TalentConceptModel
	 */
	TalentConceptModel getTalentConcept(Long id);
	
	/**
	 * 添加 人才理念
	 * @author liaoly
	 * @date 2020年11月6日 下午3:23:48
	 * @param talentConcept : 参数对象
	 * @return TalentConceptModel
	 */
	TalentConceptModel addTalentConcept(TalentConceptModel talentConcept);
	
	/**
	 * 保存 人才理念
	 * @author liaoly
	 * @date 2020年11月6日 下午2:46:43
	 * @param talentConcept : 参数对象
	 * void
	 */
	void saveTalentConcept(TalentConceptModel talentConcept);

	/**
	 * 删除 人才理念
	 * @author liaoly
	 * @date 2020年11月6日 下午2:59:24
	 * @param id : talentConcept.id
	 * @param adminName : 操作账号昵称(冗余)
	 * @param adminId : 操作账号id
	 * void
	 */
	void delTalentConcept(Long id, String adminName, Long adminId);

	/**
	 * 删除 人才理念
	 * @author liaoly
	 * @date 2020年11月6日 下午3:06:17
	 * @param idArr : talentConcept.id集合
	 * @param adminName : 操作账号昵称(冗余)
	 * @param adminId : 操作账号id
	 * void
	 */
	void delTalentConcept(Long[] idArr, String adminName, Long adminId);

	/**
	 * 更新 人才理念 状态(只会更新业务字段：status)
	 * @author liaoly
	 * @date 2020年11月6日 下午3:12:31
	 * @param talentConcept : 参数对象
	 * void
	 */
	void saveStatus(TalentConcept talentConcept);

	/**
	 * 批量更新 人才理念 状态(只会更新业务字段：status)
	 * @author liaoly
	 * @date 2020年11月19日 下午2:42:07
	 * @param idArr
	 * @param status
	 * @param adminId
	 * @param adminName void
	 */
	void batchSaveStatus(Long[] idArr, Integer status, Long adminId, String adminName);
}
