package cn.smarthse.modules.giian.service.sys;

import java.util.List;

import cn.smarthse.modules.datacentre.model.system.SysFileModel;
import cn.smarthse.modules.giian.entity.sys.SysFile;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * giian-service文件上传服务
 * @Description 
 * @Author liaoly
 * @Date 2020年3月2日 上午9:46:39
 */
public interface ISysFileService extends IBaseService<SysFile> {
	
	/**
	 * 根据用户MD5读取附件信息
	 * @param filehash
	 * @return
	 */
	SysFile getFileByHash(String filehash);
	
	/**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     * @param ids 如 "1,2,3,4"
     * @return
     */
	List<SysFile> getListByIds(String ids);
	
	/**
	 * 根据文件id查询文件详情
	 * @param fileId : 文件id
	 * @return
	 */
	SysFileModel getFileById(Long fileId);
	
	/**
	 * 根据文件hash值获取文件
	 * @param filehash : 文件hash值
	 * @return
	 */
	SysFileModel getFileModelByHash(String filehash);
	
	/**
	 * 根据文件Id获得文件全路径地址
	 * @param fileId : 文件id
	 * @return
	 */
	String getFileUrl(Long fileId);
	
	/**
     * 根据主键字符串进行查询，类中只有存在一个带有@Id注解的字段
     *
     * @param ids 如 "1,2,3,4"
     * @return
     */
	List<SysFileModel> getFileListByIds(String ids);
	
	/**
	 * 通用的文件上传接口
	 * @param record : 文件对象
	 * @param userId : 操作账号id，可为空
	 * @return
	 */
	SysFileModel addSysFile(SysFileModel record, Long userId);
}
