
package cn.smarthse.modules.giian.service.sys;

import java.util.List;

import com.github.pagehelper.PageInfo;

import cn.smarthse.modules.giian.entity.sys.GiianLog;
import cn.smarthse.modules.giian.enums.sys.GiianlogEnum;
import cn.smarthse.modules.giian.model.sys.GiianLogModel;
import cn.smarthse.modules.platform.core.framework.service.IBaseService;

/**
 * 
 * 各个模块 _操作记录表
 * 
 * @Author liaoly(廖凌云) [1302013247@qq.com]
 * @Date 2020年11月12日 下午4:29:01
 */
public interface IGiianLogService extends IBaseService<GiianLog>{

	/**
	 * 添加 操作记录 (只比较并记录有@Giianlog日志注解的字段)
	 * @author liaoly
	 * @date 2020年11月12日 下午4:51:13
	 * @param oldObject : 操作之前的对象
	 * @param newObject : 操作之后的对象
	 * @return List<GiianLog>
	 */
	List<GiianLog> addGiianLogs(GiianlogEnum giianlogEnum, Object oldObject, Object newObject);

	/**
	 * 查询编辑记录列表数据
	 * @author liaoly
	 * @date 2020年11月13日 上午8:20:31
	 * @param businessId : 业务数据id
	 * @param giianlogEnum : 编辑记录类型
	 * @param page : 分页查询参数
	 * @param pageSize : 分页查询参数
	 * @return PageInfo<GiianLogModel>
	 */
	PageInfo<GiianLogModel> getGiianLogList(Long businessId, GiianlogEnum aboutUs, Integer page, Integer pageSize);

	/**
	 * 查询编辑记录列表数据
	 * @author liaoly
	 * @date 2020年11月13日 上午8:25:15
	 * @param businessId : 业务数据id
	 * @param giianlogEnum : 编辑记录类型
	 * @return List<GiianLogModel>
	 */
	List<GiianLogModel> getGiianLogList(Long businessId, GiianlogEnum giianlogEnum);
}
